/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.requests.CacheableRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadNextBlockOfChildrenRequest
extends CacheableRequest {
    public static final int INDEX_NOT_USED = -1;
    private static final long serialVersionUID = 1L;
    private final Location of;
    private final List<Location> children = new LinkedList<Location>();
    private final Location startingAfter;
    private final int count;
    private Location actualLocation;

    public ReadNextBlockOfChildrenRequest(Location of, Location startingAfter, int count) {
        CheckArg.isNotNull((Object)of, (String)"of");
        CheckArg.isNotNull((Object)startingAfter, (String)"startingAfter");
        CheckArg.isPositive((int)count, (String)"count");
        this.of = of;
        this.startingAfter = startingAfter;
        this.count = count;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location of() {
        return this.of;
    }

    public int count() {
        return this.count;
    }

    public Location startingAfter() {
        return this.startingAfter;
    }

    public List<Location> getChildren() {
        return this.children;
    }

    public void addChild(Location child) {
        CheckArg.isNotNull((Object)child, (String)"child");
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        Location child = new Location(pathToChild, firstIdProperty, remainingIdProperties);
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property idProperty) {
        Location child = new Location(pathToChild, idProperty);
        this.children.add(child);
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.of.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.of}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            ReadNextBlockOfChildrenRequest that = (ReadNextBlockOfChildrenRequest)obj;
            if (!this.of().equals(that.of())) {
                return false;
            }
            if (!this.startingAfter().equals(that.startingAfter())) {
                return false;
            }
            return this.count() == that.count();
        }
        return false;
    }

    public String toString() {
        if (this.count() == 1) {
            return "read one child of " + this.of() + " starting after " + this.startingAfter();
        }
        return "read " + this.count() + " children of " + this.of();
    }
}

