/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.requests.CacheableRequest;

public class ReadPropertyRequest
extends CacheableRequest {
    private static final long serialVersionUID = 1L;
    private final Location on;
    private final Name propertyName;
    private Property property;
    private Location actualLocation;

    public ReadPropertyRequest(Location on, Name propertyName) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        this.on = on;
        this.propertyName = propertyName;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Location on() {
        return this.on;
    }

    public Name named() {
        return this.propertyName;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        if (property != null) {
            CheckArg.isEquals((Object)property.getName(), (String)"property's name", (Object)this.named(), (String)"property name");
        }
        this.property = property;
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.on.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.on}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            ReadPropertyRequest that = (ReadPropertyRequest)obj;
            if (!this.on().equals(that.on())) {
                return false;
            }
            return this.named().equals(that.named());
        }
        return false;
    }

    public String toString() {
        return "read " + this.named() + " property at " + this.on();
    }
}

