/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.requests.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovePropertiesRequest
extends Request
implements Iterable<Name> {
    private static final long serialVersionUID = 1L;
    private final Location from;
    private final Set<Name> propertyNames;
    private Location actualLocation;

    public RemovePropertiesRequest(Location from, Name ... propertyNames) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotEmpty((Object[])propertyNames, (String)"propertyNames");
        this.from = from;
        HashSet<Name> names = new HashSet<Name>();
        for (Name name : propertyNames) {
            if (name == null) continue;
            names.add(name);
        }
        this.propertyNames = Collections.unmodifiableSet(names);
    }

    public RemovePropertiesRequest(Location from, Iterable<Name> propertyNames) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotNull(propertyNames, (String)"propertyNames");
        this.from = from;
        HashSet<Name> names = new HashSet<Name>();
        for (Name name : propertyNames) {
            if (name == null) continue;
            names.add(name);
        }
        this.propertyNames = Collections.unmodifiableSet(names);
        CheckArg.isNotEmpty(this.propertyNames, (String)"propertyNames");
    }

    public RemovePropertiesRequest(Location from, Iterator<Name> propertyNames) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotNull(propertyNames, (String)"propertyNames");
        this.from = from;
        HashSet<Name> names = new HashSet<Name>();
        while (propertyNames.hasNext()) {
            Name name = propertyNames.next();
            if (name == null) continue;
            names.add(name);
        }
        this.propertyNames = Collections.unmodifiableSet(names);
        CheckArg.isNotEmpty(this.propertyNames, (String)"propertyNames");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Location from() {
        return this.from;
    }

    @Override
    public Iterator<Name> iterator() {
        return this.propertyNames.iterator();
    }

    public Collection<Name> propertyNames() {
        return this.propertyNames;
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.from.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.from}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            RemovePropertiesRequest that = (RemovePropertiesRequest)obj;
            if (!this.from().equals(that.from())) {
                return false;
            }
            return ((Object)this.propertyNames()).equals(that.propertyNames());
        }
        return false;
    }

    public String toString() {
        return "remove from " + this.from() + " properties named " + this.propertyNames();
    }
}

