/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.requests.Request;

public class RenameNodeRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final Name newName;
    private Location actualOldLocation;
    private Location actualNewLocation;

    public RenameNodeRequest(Location at, Name newName) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)newName, (String)"newName");
        this.at = at;
        this.newName = newName;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Location at() {
        return this.at;
    }

    public Name toName() {
        return this.newName;
    }

    public void setActualLocations(Location oldLocation, Location newLocation) {
        if (!this.at.isSame(oldLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{oldLocation, this.at}));
        }
        assert (oldLocation != null);
        if (newLocation == null) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{newLocation, this.at}));
        }
        if (!oldLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{oldLocation}));
        }
        if (!newLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(new Object[]{newLocation}));
        }
        Path newPath = newLocation.getPath();
        if (!newPath.getParent().equals(oldLocation.getPath().getParent())) {
            String msg = GraphI18n.actualNewLocationMustHaveSameParentAsOldLocation.text(new Object[]{newLocation, oldLocation});
            throw new IllegalArgumentException(msg);
        }
        if (!newPath.getLastSegment().getName().equals(this.toName())) {
            String msg = GraphI18n.actualNewLocationMustHaveSameNameAsRequest.text(new Object[]{newLocation, this.toName()});
            throw new IllegalArgumentException(msg);
        }
        this.actualNewLocation = newLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualOldLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualNewLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            RenameNodeRequest that = (RenameNodeRequest)obj;
            if (!this.at().equals(that.at())) {
                return false;
            }
            return this.toName().equals(that.toName());
        }
        return false;
    }

    public String toString() {
        return "rename node at " + this.at() + " to " + this.toName();
    }
}

