/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.requests.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePropertiesRequest
extends Request
implements Iterable<Property> {
    private static final long serialVersionUID = 1L;
    private final Location on;
    private final List<Property> properties;
    private Location actualLocation;

    public UpdatePropertiesRequest(Location on, Property ... properties) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotEmpty((Object[])properties, (String)"properties");
        this.on = on;
        this.properties = Collections.unmodifiableList(Arrays.asList(properties));
    }

    public UpdatePropertiesRequest(Location on, Iterable<Property> properties) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotNull(properties, (String)"properties");
        this.on = on;
        LinkedList<Property> props = new LinkedList<Property>();
        for (Property property : properties) {
            if (property == null) continue;
            props.add(property);
        }
        this.properties = Collections.unmodifiableList(props);
        CheckArg.isNotEmpty(this.properties, (String)"properties");
    }

    public UpdatePropertiesRequest(Location on, Iterator<Property> properties) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotNull(properties, (String)"properties");
        this.on = on;
        LinkedList<Property> props = new LinkedList<Property>();
        while (properties.hasNext()) {
            Property property = properties.next();
            if (property == null) continue;
            props.add(property);
        }
        this.properties = Collections.unmodifiableList(props);
        CheckArg.isNotEmpty(this.properties, (String)"properties");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Location on() {
        return this.on;
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties.iterator();
    }

    public Collection<Property> properties() {
        return this.properties;
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.on.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.on}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            UpdatePropertiesRequest that = (UpdatePropertiesRequest)obj;
            if (!this.on().equals(that.on())) {
                return false;
            }
            return ((Object)this.properties()).equals(that.properties());
        }
        return false;
    }

    public String toString() {
        return "update properties on " + this.on() + " to " + this.properties();
    }
}

