/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests.processor;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.requests.CompositeRequest;
import org.jboss.dna.graph.requests.CopyBranchRequest;
import org.jboss.dna.graph.requests.CreateNodeRequest;
import org.jboss.dna.graph.requests.DeleteBranchRequest;
import org.jboss.dna.graph.requests.MoveBranchRequest;
import org.jboss.dna.graph.requests.ReadAllChildrenRequest;
import org.jboss.dna.graph.requests.ReadAllPropertiesRequest;
import org.jboss.dna.graph.requests.ReadBlockOfChildrenRequest;
import org.jboss.dna.graph.requests.ReadBranchRequest;
import org.jboss.dna.graph.requests.ReadNextBlockOfChildrenRequest;
import org.jboss.dna.graph.requests.ReadNodeRequest;
import org.jboss.dna.graph.requests.ReadPropertyRequest;
import org.jboss.dna.graph.requests.RemovePropertiesRequest;
import org.jboss.dna.graph.requests.RenameNodeRequest;
import org.jboss.dna.graph.requests.Request;
import org.jboss.dna.graph.requests.UpdatePropertiesRequest;
import org.jboss.dna.graph.requests.processor.RequestProcessor;

public class LoggingRequestProcessor
extends RequestProcessor {
    private final RequestProcessor delegate;
    private final Logger logger;
    private final Logger.Level level;

    public LoggingRequestProcessor(RequestProcessor delegate, Logger logger, Logger.Level level) {
        super(delegate.getSourceName(), delegate.getExecutionContext());
        CheckArg.isNotNull((Object)logger, (String)"logger");
        this.delegate = delegate;
        this.logger = logger;
        this.level = level != null ? level : Logger.Level.TRACE;
    }

    public void process(CopyBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CreateNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(DeleteBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(MoveBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadAllChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadAllPropertiesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(UpdatePropertiesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CompositeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadBlockOfChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadPropertyRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(RemovePropertiesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(RenameNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(Request request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void close() {
        this.logger.log(this.level, GraphI18n.closingRequestProcessor, new Object[0]);
        this.delegate.close();
        this.logger.log(this.level, GraphI18n.closingRequestProcessor, new Object[0]);
    }
}

