/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.requests.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.basic.BasicEmptyProperty;
import org.jboss.dna.graph.requests.CompositeRequest;
import org.jboss.dna.graph.requests.CopyBranchRequest;
import org.jboss.dna.graph.requests.CreateNodeRequest;
import org.jboss.dna.graph.requests.DeleteBranchRequest;
import org.jboss.dna.graph.requests.MoveBranchRequest;
import org.jboss.dna.graph.requests.ReadAllChildrenRequest;
import org.jboss.dna.graph.requests.ReadAllPropertiesRequest;
import org.jboss.dna.graph.requests.ReadBlockOfChildrenRequest;
import org.jboss.dna.graph.requests.ReadBranchRequest;
import org.jboss.dna.graph.requests.ReadNextBlockOfChildrenRequest;
import org.jboss.dna.graph.requests.ReadNodeRequest;
import org.jboss.dna.graph.requests.ReadPropertyRequest;
import org.jboss.dna.graph.requests.RemovePropertiesRequest;
import org.jboss.dna.graph.requests.RenameNodeRequest;
import org.jboss.dna.graph.requests.Request;
import org.jboss.dna.graph.requests.UpdatePropertiesRequest;

@Immutable
public abstract class RequestProcessor {
    private final ExecutionContext context;
    private final String sourceName;
    private final DateTime nowInUtc;

    protected RequestProcessor(String sourceName, ExecutionContext context) {
        this(sourceName, context, null);
    }

    protected RequestProcessor(String sourceName, ExecutionContext context, DateTime now) {
        CheckArg.isNotEmpty((String)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)context, (String)"context");
        this.context = context;
        this.sourceName = sourceName;
        this.nowInUtc = now != null ? now : context.getValueFactories().getDateFactory().createUtc();
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    protected DateTime getNowInUtc() {
        return this.nowInUtc;
    }

    public void process(Request request) {
        if (request == null) {
            return;
        }
        if (request.isCancelled()) {
            return;
        }
        if (request instanceof CompositeRequest) {
            this.process((CompositeRequest)request);
        } else if (request instanceof CopyBranchRequest) {
            this.process((CopyBranchRequest)request);
        } else if (request instanceof CreateNodeRequest) {
            this.process((CreateNodeRequest)request);
        } else if (request instanceof DeleteBranchRequest) {
            this.process((DeleteBranchRequest)request);
        } else if (request instanceof MoveBranchRequest) {
            this.process((MoveBranchRequest)request);
        } else if (request instanceof ReadAllChildrenRequest) {
            this.process((ReadAllChildrenRequest)request);
        } else if (request instanceof ReadNextBlockOfChildrenRequest) {
            this.process((ReadNextBlockOfChildrenRequest)request);
        } else if (request instanceof ReadBlockOfChildrenRequest) {
            this.process((ReadBlockOfChildrenRequest)request);
        } else if (request instanceof ReadBranchRequest) {
            this.process((ReadBranchRequest)request);
        } else if (request instanceof ReadNodeRequest) {
            this.process((ReadNodeRequest)request);
        } else if (request instanceof ReadAllPropertiesRequest) {
            this.process((ReadAllPropertiesRequest)request);
        } else if (request instanceof ReadPropertyRequest) {
            this.process((ReadPropertyRequest)request);
        } else if (request instanceof RemovePropertiesRequest) {
            this.process((RemovePropertiesRequest)request);
        } else if (request instanceof RenameNodeRequest) {
            this.process((RenameNodeRequest)request);
        } else if (request instanceof UpdatePropertiesRequest) {
            this.process((UpdatePropertiesRequest)request);
        }
    }

    public void process(CompositeRequest request) {
        if (request == null) {
            return;
        }
        int numberOfErrors = 0;
        Throwable firstError = null;
        for (Request embedded : request) {
            assert (embedded != null);
            if (embedded.isCancelled()) {
                return;
            }
            this.process(embedded);
            if (!embedded.hasError()) continue;
            if (numberOfErrors == 0) {
                firstError = embedded.getError();
            }
            ++numberOfErrors;
        }
        if (firstError == null) {
            return;
        }
        if (numberOfErrors == 1) {
            request.setError(firstError);
        } else {
            String msg = GraphI18n.multipleErrorsWhileExecutingRequests.text(new Object[]{numberOfErrors, request.size()});
            request.setError(new RepositorySourceException(this.getSourceName(), msg));
        }
    }

    public abstract void process(CopyBranchRequest var1);

    public abstract void process(CreateNodeRequest var1);

    public abstract void process(DeleteBranchRequest var1);

    public abstract void process(MoveBranchRequest var1);

    public abstract void process(ReadAllChildrenRequest var1);

    public void process(ReadBlockOfChildrenRequest request) {
        if (request == null) {
            return;
        }
        ReadAllChildrenRequest readAll = new ReadAllChildrenRequest(request.of());
        this.process(readAll);
        if (readAll.hasError()) {
            request.setError(readAll.getError());
            return;
        }
        List<Location> allChildren = readAll.getChildren();
        if (allChildren.size() < request.startingAtIndex()) {
            return;
        }
        int endIndex = Math.min(request.endingBefore(), allChildren.size());
        for (int i = request.startingAtIndex(); i != endIndex; ++i) {
            request.addChild(allChildren.get(i));
        }
        request.setActualLocationOfNode(readAll.getActualLocationOfNode());
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        if (request == null) {
            return;
        }
        ReadAllChildrenRequest readAll = new ReadAllChildrenRequest(request.of());
        this.process(readAll);
        if (readAll.hasError()) {
            request.setError(readAll.getError());
            return;
        }
        List<Location> allChildren = readAll.getChildren();
        boolean found = false;
        int count = 0;
        for (Location child : allChildren) {
            if (count > request.count()) break;
            if (!found) {
                found = child.equals(request.startingAfter());
                continue;
            }
            ++count;
            request.addChild(child);
        }
        request.setActualLocationOfNode(readAll.getActualLocationOfNode());
    }

    public void process(ReadBranchRequest request) {
        if (request == null) {
            return;
        }
        LinkedList<LocationWithDepth> locationsToRead = new LinkedList<LocationWithDepth>();
        locationsToRead.add(new LocationWithDepth(request.at(), 1));
        boolean first = true;
        while (locationsToRead.peek() != null) {
            if (request.isCancelled()) {
                return;
            }
            LocationWithDepth read = (LocationWithDepth)locationsToRead.poll();
            if (read.depth > request.maximumDepth()) break;
            ReadNodeRequest readNode = new ReadNodeRequest(read.location);
            this.process(readNode);
            if (readNode.hasError()) {
                request.setError(readNode.getError());
                return;
            }
            Location actualLocation = readNode.getActualLocationOfNode();
            if (first) {
                request.setActualLocationOfNode(actualLocation);
                first = false;
            }
            request.setChildren(actualLocation, readNode.getChildren());
            request.setProperties(actualLocation, readNode.getProperties());
            for (Location child : readNode.getChildren()) {
                locationsToRead.add(new LocationWithDepth(child, read.depth + 1));
            }
        }
    }

    public abstract void process(ReadAllPropertiesRequest var1);

    public void process(ReadNodeRequest request) {
        if (request == null) {
            return;
        }
        ReadAllPropertiesRequest readProperties = new ReadAllPropertiesRequest(request.at());
        this.process(readProperties);
        if (readProperties.hasError()) {
            request.setError(readProperties.getError());
            return;
        }
        request.setActualLocationOfNode(readProperties.getActualLocationOfNode());
        ReadAllChildrenRequest readChildren = new ReadAllChildrenRequest(request.at());
        this.process(readChildren);
        if (readChildren.hasError()) {
            request.setError(readChildren.getError());
            return;
        }
        if (request.isCancelled()) {
            return;
        }
        for (Property property : readProperties) {
            request.addProperty(property);
        }
        for (Location child : readChildren) {
            request.addChild(child);
        }
    }

    public void process(ReadPropertyRequest request) {
        if (request == null) {
            return;
        }
        ReadAllPropertiesRequest readNode = new ReadAllPropertiesRequest(request.on());
        this.process(readNode);
        if (readNode.hasError()) {
            request.setError(readNode.getError());
            return;
        }
        Property property = readNode.getPropertiesByName().get(request.named());
        request.setProperty(property);
        request.setActualLocationOfNode(readNode.getActualLocationOfNode());
    }

    public void process(RemovePropertiesRequest request) {
        if (request == null) {
            return;
        }
        Collection<Name> names = request.propertyNames();
        if (names.isEmpty()) {
            return;
        }
        ArrayList<Property> emptyProperties = new ArrayList<Property>(names.size());
        for (Name propertyName : names) {
            emptyProperties.add(new BasicEmptyProperty(propertyName));
        }
        UpdatePropertiesRequest update = new UpdatePropertiesRequest(request.from(), emptyProperties);
        this.process(update);
        if (update.hasError()) {
            request.setError(update.getError());
        }
        request.setActualLocationOfNode(update.getActualLocationOfNode());
    }

    public abstract void process(UpdatePropertiesRequest var1);

    public void process(RenameNodeRequest request) {
        if (request == null) {
            return;
        }
        Location from = request.at();
        if (!from.hasPath()) {
            throw new UnsupportedOperationException();
        }
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(from.getPath(), request.toName());
        Location to = new Location(newPath);
        MoveBranchRequest move = new MoveBranchRequest(from, to);
        this.process(move);
        request.setActualLocations(move.getActualLocationBefore(), move.getActualLocationAfter());
    }

    public void close() {
    }

    @Immutable
    protected static class LocationWithDepth {
        protected final Location location;
        protected final int depth;

        protected LocationWithDepth(Location location, int depth) {
            this.location = location;
            this.depth = depth;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public String toString() {
            return this.location.toString() + " at depth " + this.depth;
        }
    }
}

