/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.text.XmlNameEncoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.BasicExecutionContext;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.properties.basic.LocalNamespaceRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;

@NotThreadSafe
public class XmlHandler
extends DefaultHandler2 {
    private final ExecutionContext context;
    public static TextDecoder DEFAULT_DECODER = new XmlNameEncoder();
    public static AttributeScoping DEFAULT_ATTRIBUTE_SCOPING = AttributeScoping.USE_DEFAULT_NAMESPACE;
    protected final Destination destination;
    protected final Name nameAttribute;
    protected final Name typeAttribute;
    protected final Name typeAttributeValue;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final PropertyFactory propertyFactory;
    protected final NamespaceRegistry namespaceRegistry;
    protected final TextDecoder decoder;
    private final Map<String, LinkedList<String>> prefixStackByUri = new HashMap<String, LinkedList<String>>();
    private final AttributeScoping attributeScoping;
    protected Path currentPath;
    protected boolean skipFirstElement;
    protected final List<Property> properties = new ArrayList<Property>();
    protected final Object[] propertyValues = new Object[1];

    public XmlHandler(Destination destination, boolean skipRootElement, Path parent, TextDecoder textDecoder, Name nameAttribute, Name typeAttribute, Name typeAttributeValue, AttributeScoping scoping) {
        CheckArg.isNotNull((Object)destination, (String)"destination");
        assert (destination != null);
        this.destination = destination;
        this.nameAttribute = nameAttribute;
        this.typeAttribute = typeAttribute;
        this.typeAttributeValue = typeAttributeValue;
        this.decoder = textDecoder != null ? textDecoder : DEFAULT_DECODER;
        this.skipFirstElement = skipRootElement;
        this.attributeScoping = scoping != null ? scoping : DEFAULT_ATTRIBUTE_SCOPING;
        this.context = destination.getExecutionContext();
        assert (this.context != null);
        LocalNamespaceRegistry namespaceRegistry = new LocalNamespaceRegistry(this.context.getNamespaceRegistry());
        BasicExecutionContext localContext = new BasicExecutionContext(this.context, namespaceRegistry);
        this.nameFactory = localContext.getValueFactories().getNameFactory();
        this.pathFactory = localContext.getValueFactories().getPathFactory();
        this.propertyFactory = localContext.getPropertyFactory();
        this.namespaceRegistry = localContext.getNamespaceRegistry();
        assert (this.nameFactory != null);
        assert (this.pathFactory != null);
        assert (this.propertyFactory != null);
        assert (this.namespaceRegistry != null);
        Path path = this.currentPath = parent != null ? parent : this.pathFactory.createRootPath();
        assert (this.currentPath != null);
    }

    public void startPrefixMapping(String prefix, String uri) {
        assert (uri != null);
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        if (prefixStack == null) {
            prefixStack = new LinkedList();
            this.prefixStackByUri.put(uri, prefixStack);
        }
        prefixStack.addFirst(prefix);
        if (!this.namespaceRegistry.isRegisteredNamespaceUri(uri)) {
            NamespaceRegistry contextRegistry = this.context.getNamespaceRegistry();
            if (contextRegistry.getNamespaceForPrefix(prefix) != null) {
                this.context.getNamespaceRegistry().getPrefixForNamespaceUri(uri, true);
                this.namespaceRegistry.register(prefix, uri);
            } else {
                this.context.getNamespaceRegistry().register(prefix, uri);
            }
        } else {
            this.namespaceRegistry.register(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) {
        assert (prefix != null);
        String uri = this.namespaceRegistry.getNamespaceForPrefix(prefix);
        assert (uri != null);
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        assert (prefixStack != null);
        assert (!prefixStack.isEmpty());
        String existingPrefix = prefixStack.removeFirst();
        assert (prefix.equals(existingPrefix));
        if (prefixStack.isEmpty()) {
            this.namespaceRegistry.unregister(uri);
            this.prefixStackByUri.remove(uri);
        } else {
            String previous = prefixStack.getFirst();
            this.namespaceRegistry.register(previous, uri);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) {
        if (this.skipFirstElement) {
            this.skipFirstElement = false;
            return;
        }
        assert (localName != null);
        Name nodeName = null;
        this.properties.clear();
        Name typePropertyValue = null;
        int len = attributes.getLength();
        for (int i = 0; i != len; ++i) {
            String attributeLocalName = attributes.getLocalName(i);
            String attributeUri = attributes.getURI(i);
            Name attributeName = null;
            if ((attributeUri == null || attributeUri.length() == 0) && attributes.getQName(i).indexOf(58) == -1) {
                switch (this.attributeScoping) {
                    case INHERIT_ELEMENT_NAMESPACE: {
                        attributeName = this.nameFactory.create(uri, attributeLocalName, this.decoder);
                        break;
                    }
                    case USE_DEFAULT_NAMESPACE: {
                        attributeName = (Name)this.nameFactory.create(attributeLocalName, this.decoder);
                    }
                }
            } else {
                attributeName = this.nameFactory.create(attributeUri, attributeLocalName, this.decoder);
            }
            assert (attributeName != null);
            if (nodeName == null && attributeName.equals(this.nameAttribute)) {
                nodeName = (Name)this.nameFactory.create(attributes.getValue(i));
                continue;
            }
            if (typePropertyValue == null && attributeName.equals(this.typeAttribute)) {
                typePropertyValue = this.nameFactory.create(attributes.getValue(i));
                continue;
            }
            Property property = this.createProperty(attributeName, attributes.getValue(i));
            this.properties.add(property);
        }
        if (nodeName == null) {
            nodeName = this.nameFactory.create(uri, localName, this.decoder);
        } else {
            typePropertyValue = this.nameFactory.create(uri, localName, this.decoder);
        }
        if (this.typeAttribute != null) {
            if (typePropertyValue == null) {
                typePropertyValue = this.typeAttributeValue;
            }
            if (typePropertyValue != null) {
                this.propertyValues[0] = typePropertyValue;
                Property property = this.propertyFactory.create(this.typeAttribute, this.propertyValues);
                this.properties.add(property);
            }
        }
        this.currentPath = this.pathFactory.create(this.currentPath, nodeName);
        this.destination.create(this.currentPath, this.properties);
    }

    public void endElement(String uri, String localName, String name) {
        this.currentPath = this.currentPath.getParent();
    }

    public void endDocument() {
        this.destination.submit();
    }

    protected Property createProperty(Name propertyName, Object value) {
        this.propertyValues[0] = value;
        Property result = this.propertyFactory.create(propertyName, this.propertyValues);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public static interface Destination {
        public ExecutionContext getExecutionContext();

        public void create(Path var1, List<Property> var2);

        public void create(Path var1, Property var2, Property ... var3);

        public void submit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeScoping {
        USE_DEFAULT_NAMESPACE,
        INHERIT_ELEMENT_NAMESPACE;

    }
}

