/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.security.AccessControlContext;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.jboss.dna.graph.mimetype.MimeTypeDetector;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.property.ValueFactories;
import org.jboss.dna.graph.property.basic.BasicPropertyFactory;
import org.jboss.dna.graph.property.basic.SimpleNamespaceRegistry;
import org.jboss.dna.graph.property.basic.StandardValueFactories;
import org.jboss.dna.graph.property.basic.ThreadSafeNamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ExecutionContext
implements ClassLoaderFactory,
Cloneable {
    private final ClassLoaderFactory classLoaderFactory;
    private final LoginContext loginContext;
    private final AccessControlContext accessControlContext;
    private final Subject subject;
    private final PropertyFactory propertyFactory;
    private final ValueFactories valueFactories;
    private final NamespaceRegistry namespaceRegistry;
    private final MimeTypeDetector mimeTypeDetector;

    public ExecutionContext() {
        this(null, null, null, null, null, null, null);
        this.initializeDefaultNamespaces(this.getNamespaceRegistry());
    }

    protected ExecutionContext(ExecutionContext original) {
        CheckArg.isNotNull((Object)original, (String)"original");
        this.loginContext = original.getLoginContext();
        this.accessControlContext = original.getAccessControlContext();
        this.subject = original.getSubject();
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
    }

    protected ExecutionContext(ExecutionContext original, AccessControlContext accessControlContext) {
        CheckArg.isNotNull((Object)original, (String)"original");
        CheckArg.isNotNull((Object)accessControlContext, (String)"accessControlContext");
        this.loginContext = null;
        this.accessControlContext = accessControlContext;
        this.subject = Subject.getSubject(this.accessControlContext);
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
    }

    protected ExecutionContext(ExecutionContext original, LoginContext loginContext) {
        CheckArg.isNotNull((Object)original, (String)"original");
        CheckArg.isNotNull((Object)loginContext, (String)"loginContext");
        this.loginContext = loginContext;
        this.accessControlContext = null;
        this.subject = this.loginContext.getSubject();
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
    }

    protected ExecutionContext(LoginContext loginContext, AccessControlContext accessControlContext, NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory, MimeTypeDetector mimeTypeDetector, ClassLoaderFactory classLoaderFactory) {
        this.loginContext = loginContext;
        this.accessControlContext = accessControlContext;
        this.subject = loginContext == null ? Subject.getSubject(accessControlContext == null ? AccessController.getContext() : accessControlContext) : loginContext.getSubject();
        this.namespaceRegistry = namespaceRegistry != null ? namespaceRegistry : new ThreadSafeNamespaceRegistry(new SimpleNamespaceRegistry());
        this.valueFactories = valueFactories == null ? new StandardValueFactories(this.namespaceRegistry) : valueFactories;
        this.propertyFactory = propertyFactory == null ? new BasicPropertyFactory(this.valueFactories) : propertyFactory;
        this.classLoaderFactory = classLoaderFactory == null ? new StandardClassLoaderFactory() : classLoaderFactory;
        this.mimeTypeDetector = mimeTypeDetector != null ? mimeTypeDetector : new ExtensionBasedMimeTypeDetector();
    }

    protected ClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz);
    }

    public Logger getLogger(String name) {
        return Logger.getLogger((String)name);
    }

    public MimeTypeDetector getMimeTypeDetector() {
        return this.mimeTypeDetector;
    }

    public AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    public ClassLoader getClassLoader(String ... classpath) {
        return this.classLoaderFactory.getClassLoader(classpath);
    }

    public ExecutionContext with(NamespaceRegistry namespaceRegistry) {
        return new ExecutionContext(this.getLoginContext(), this.getAccessControlContext(), namespaceRegistry, null, null, this.getMimeTypeDetector(), this.getClassLoaderFactory());
    }

    public ExecutionContext with(MimeTypeDetector mimeTypeDetector) {
        return new ExecutionContext(this.getLoginContext(), this.getAccessControlContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), mimeTypeDetector, this.getClassLoaderFactory());
    }

    public ExecutionContext with(ClassLoaderFactory classLoaderFactory) {
        return new ExecutionContext(this.getLoginContext(), this.getAccessControlContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), classLoaderFactory);
    }

    public ExecutionContext create(AccessControlContext accessControlContext) {
        return new ExecutionContext(this, accessControlContext);
    }

    public ExecutionContext create(LoginContext loginContext) {
        return new ExecutionContext(this, loginContext);
    }

    public ExecutionContext with(String name) throws LoginException {
        return new ExecutionContext(this, new LoginContext(name));
    }

    public ExecutionContext with(String name, Subject subject) throws LoginException {
        return new ExecutionContext(this, new LoginContext(name, subject));
    }

    public ExecutionContext with(String name, CallbackHandler callbackHandler) throws LoginException {
        return new ExecutionContext(this, new LoginContext(name, callbackHandler));
    }

    public ExecutionContext with(String name, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        return new ExecutionContext(this, new LoginContext(name, subject, callbackHandler));
    }

    public ExecutionContext clone() {
        return new ExecutionContext(this);
    }

    public String toString() {
        return "Execution context for " + this.getSubject();
    }

    protected void initializeDefaultNamespaces(NamespaceRegistry namespaceRegistry) {
        if (namespaceRegistry == null) {
            return;
        }
        namespaceRegistry.register("jcr", "http://www.jcp.org/jcr/1.0");
        namespaceRegistry.register("mix", "http://www.jcp.org/jcr/mix/1.0");
        namespaceRegistry.register("nt", "http://www.jcp.org/jcr/nt/1.0");
        namespaceRegistry.register("dna", "http://www.jboss.org/dna/1.0");
    }
}

