/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.LocationWithPathAndProperty;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class LocationWithPathAndProperties
extends Location {
    private final Path path;
    private final List<Property> idProperties;
    private final int hashCode;

    LocationWithPathAndProperties(Path path, List<Property> idProperties) {
        assert (idProperties != null);
        assert (!idProperties.isEmpty());
        this.path = path;
        this.idProperties = Collections.unmodifiableList(idProperties);
        this.hashCode = HashCode.compute((Object[])new Object[]{path, idProperties});
    }

    @Override
    public final Path getPath() {
        return this.path;
    }

    @Override
    public final List<Property> getIdProperties() {
        return this.idProperties;
    }

    @Override
    public final boolean hasIdProperties() {
        return this.idProperties.size() > 0;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        if (this.hasIdProperties()) {
            List<Property> newIdProperties = new ArrayList<Property>(this.idProperties.size() + 1);
            for (Property property : this.idProperties) {
                if (newIdProperty.getName().equals(property.getName())) continue;
                newIdProperties.add(property);
            }
            newIdProperties.add(newIdProperty);
            newIdProperties = Collections.unmodifiableList(newIdProperties);
            return new LocationWithPathAndProperties(this.path, newIdProperties);
        }
        return new LocationWithPathAndProperty(this.path, newIdProperty);
    }

    @Override
    public Location with(Path newPath) {
        if (newPath == null || this.getPath().equals(newPath)) {
            return this;
        }
        return new LocationWithPathAndProperties(newPath, this.idProperties);
    }

    @Override
    public Location with(UUID uuid) {
        Property existing;
        if (uuid == null) {
            return this;
        }
        BasicSingleValueProperty newProperty = new BasicSingleValueProperty(DnaLexicon.UUID, uuid);
        if (this.hasIdProperties() && (existing = this.getIdProperty(DnaLexicon.UUID)) != null && existing.equals(newProperty)) {
            return this;
        }
        ArrayList<Property> newIdProperties = new ArrayList<Property>(this.idProperties.size() + 1);
        newIdProperties.addAll(this.idProperties);
        newIdProperties.add(newProperty);
        return new LocationWithPathAndProperties(this.path, newIdProperties);
    }
}

