/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.LocationWithPathAndProperty;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class LocationWithPathAndUuid
extends Location {
    private final Path path;
    private final List<Property> idProperties;
    private final int hashCode;

    LocationWithPathAndUuid(Path path, UUID uuid) {
        assert (path != null);
        assert (uuid != null);
        this.path = path;
        this.idProperties = Collections.singletonList(new BasicSingleValueProperty(DnaLexicon.UUID, uuid));
        this.hashCode = HashCode.compute((Object[])new Object[]{this.path, this.idProperties});
    }

    @Override
    public final Path getPath() {
        return this.path;
    }

    @Override
    public final boolean hasPath() {
        return true;
    }

    @Override
    public final List<Property> getIdProperties() {
        return this.idProperties;
    }

    @Override
    public final boolean hasIdProperties() {
        return true;
    }

    @Override
    public final Property getIdProperty(Name name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        Property property = this.idProperties.get(0);
        return property.getName().equals(name) ? property : null;
    }

    @Override
    public final UUID getUuid() {
        return (UUID)this.idProperties.get(0).getFirstValue();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        Property idProperty = this.idProperties.get(0);
        if (newIdProperty.getName().equals(idProperty.getName())) {
            return new LocationWithPathAndProperty(this.path, newIdProperty);
        }
        return Location.create(this.path, idProperty, newIdProperty);
    }

    @Override
    public Location with(Path newPath) {
        if (newPath == null) {
            return Location.create(this.idProperties);
        }
        if (this.path.equals(newPath)) {
            return this;
        }
        Property idProperty = this.idProperties.get(0);
        return new LocationWithPathAndProperty(newPath, idProperty);
    }

    @Override
    public Location with(UUID uuid) {
        if (uuid == null) {
            return Location.create(this.path);
        }
        if (uuid.equals(this.getUuid())) {
            return this;
        }
        return new LocationWithPathAndUuid(this.path, uuid);
    }
}

