/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.inmemory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.connector.inmemory.InMemoryNode;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.property.PropertyType;
import org.jboss.dna.graph.property.Reference;
import org.jboss.dna.graph.property.UuidFactory;
import org.jboss.dna.graph.property.ValueFactory;
import org.jboss.dna.graph.property.basic.RootPath;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class InMemoryRepository {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected final UUID rootNodeUuid;
    private final String sourceName;
    private final String defaultWorkspaceName;
    private final Map<String, Workspace> workspaces = new HashMap<String, Workspace>();

    public InMemoryRepository(String sourceName, UUID rootNodeUuid) {
        this(sourceName, rootNodeUuid, null);
    }

    public InMemoryRepository(String sourceName, UUID rootNodeUuid, String defaultWorkspaceName) {
        CheckArg.isNotEmpty((String)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)rootNodeUuid, (String)"rootNodeUUID");
        this.rootNodeUuid = rootNodeUuid;
        this.sourceName = sourceName;
        this.defaultWorkspaceName = defaultWorkspaceName != null ? defaultWorkspaceName : "";
        this.workspaces.put(this.defaultWorkspaceName, new Workspace(this.defaultWorkspaceName));
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    @GuardedBy(value="getLock()")
    public Set<String> getWorkspaceNames() {
        return this.workspaces.keySet();
    }

    @GuardedBy(value="getLock()")
    public Workspace getWorkspace(ExecutionContext context, String name) {
        if (name == null) {
            name = this.defaultWorkspaceName;
        }
        return this.workspaces.get(name);
    }

    @GuardedBy(value="getLock()")
    public Workspace createWorkspace(ExecutionContext context, String name, CreateWorkspaceRequest.CreateConflictBehavior behavior) {
        String newName = name;
        boolean conflictingName = this.workspaces.containsKey(newName);
        if (conflictingName) {
            switch (behavior) {
                case DO_NOT_CREATE: {
                    return null;
                }
                case CREATE_WITH_ADJUSTED_NAME: {
                    int counter = 0;
                    while (this.workspaces.containsKey(newName = name + ++counter)) {
                    }
                    break;
                }
            }
        }
        assert (!this.workspaces.containsKey(newName));
        Workspace workspace = new Workspace(newName);
        this.workspaces.put(newName, workspace);
        return workspace;
    }

    @GuardedBy(value="getLock()")
    public Workspace createWorkspace(ExecutionContext context, String name, CreateWorkspaceRequest.CreateConflictBehavior existingWorkspaceBehavior, String nameOfWorkspaceToClone) {
        Workspace workspace = this.createWorkspace(context, name, existingWorkspaceBehavior);
        if (workspace == null) {
            return null;
        }
        Workspace original = this.getWorkspace(context, nameOfWorkspaceToClone);
        if (original != null) {
            InMemoryNode root = workspace.getRoot();
            InMemoryNode origRoot = original.getRoot();
            root.getProperties().clear();
            root.getProperties().putAll(origRoot.getProperties());
            for (InMemoryNode originalNode : origRoot.getChildren()) {
                original.copyNode(context, originalNode, workspace, root, originalNode.getName().getName(), true, null);
            }
        }
        return workspace;
    }

    @GuardedBy(value="getLock()")
    public boolean destroyWorkspace(String name) {
        return this.workspaces.remove(name) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Workspace {
        private final Map<UUID, InMemoryNode> nodesByUuid = new HashMap<UUID, InMemoryNode>();
        private final String name;

        protected Workspace(String name) {
            assert (name != null);
            this.name = name;
            InMemoryNode root = new InMemoryNode(InMemoryRepository.this.rootNodeUuid);
            this.nodesByUuid.put(root.getUuid(), root);
        }

        public String getName() {
            return this.name;
        }

        public InMemoryNode getRoot() {
            return this.nodesByUuid.get(InMemoryRepository.this.rootNodeUuid);
        }

        public InMemoryNode getNode(UUID uuid) {
            assert (uuid != null);
            return this.nodesByUuid.get(uuid);
        }

        protected Map<UUID, InMemoryNode> getNodesByUuid() {
            return this.nodesByUuid;
        }

        public InMemoryNode getNode(ExecutionContext context, String path) {
            assert (context != null);
            assert (path != null);
            return this.getNode((Path)context.getValueFactories().getPathFactory().create(path));
        }

        public InMemoryNode getNode(Path path) {
            assert (path != null);
            InMemoryNode node = this.getRoot();
            for (Path.Segment segment : path) {
                InMemoryNode desiredChild = null;
                for (InMemoryNode child : node.getChildren()) {
                    Path.Segment childName;
                    if (child == null || (childName = child.getName()) == null || !childName.equals(segment)) continue;
                    desiredChild = child;
                    break;
                }
                if (desiredChild != null) {
                    node = desiredChild;
                    continue;
                }
                return null;
            }
            return node;
        }

        public Path getLowestExistingPath(Path path) {
            assert (path != null);
            InMemoryNode node = this.getRoot();
            int segmentNumber = 0;
            for (Path.Segment segment : path) {
                InMemoryNode desiredChild = null;
                for (InMemoryNode child : node.getChildren()) {
                    Path.Segment childName;
                    if (child == null || (childName = child.getName()) == null || !childName.equals(segment)) continue;
                    desiredChild = child;
                    break;
                }
                if (desiredChild == null) {
                    return path.subpath(0, segmentNumber);
                }
                node = desiredChild;
                ++segmentNumber;
            }
            return RootPath.INSTANCE;
        }

        public void removeNode(ExecutionContext context, InMemoryNode node) {
            assert (context != null);
            assert (node != null);
            if (this.getRoot().equals(node)) {
                this.nodesByUuid.clear();
                InMemoryNode root = new InMemoryNode(InMemoryRepository.this.rootNodeUuid);
                this.nodesByUuid.put(root.getUuid(), root);
                return;
            }
            InMemoryNode parent = node.getParent();
            assert (parent != null);
            parent.getChildren().remove(node);
            this.correctSameNameSiblingIndexes(context, parent, node.getName().getName());
            this.removeUuidReference(node);
        }

        protected void removeUuidReference(InMemoryNode node) {
            this.nodesByUuid.remove(node.getUuid());
            for (InMemoryNode child : node.getChildren()) {
                this.removeUuidReference(child);
            }
        }

        public InMemoryNode createNode(ExecutionContext context, String pathToNewNode) {
            assert (context != null);
            assert (pathToNewNode != null);
            Path path = (Path)context.getValueFactories().getPathFactory().create(pathToNewNode);
            if (path.isRoot()) {
                return this.getRoot();
            }
            Path parentPath = path.getParent();
            InMemoryNode parentNode = this.getNode(parentPath);
            Name name = path.getLastSegment().getName();
            return this.createNode(context, parentNode, name, null);
        }

        public InMemoryNode createNode(ExecutionContext context, InMemoryNode parentNode, Name name, UUID uuid) {
            assert (context != null);
            assert (name != null);
            if (parentNode == null) {
                parentNode = this.getRoot();
            }
            if (uuid == null) {
                uuid = UUID.randomUUID();
            }
            InMemoryNode node = new InMemoryNode(uuid);
            this.nodesByUuid.put(node.getUuid(), node);
            node.setParent(parentNode);
            int nextIndex = 1;
            if (parentNode.existingNames.contains(name)) {
                ListIterator<InMemoryNode> iter = parentNode.getChildren().listIterator(parentNode.getChildren().size());
                while (iter.hasPrevious()) {
                    InMemoryNode prev = iter.previous();
                    if (!prev.getName().getName().equals(name)) continue;
                    nextIndex = prev.getName().getIndex() + 1;
                    break;
                }
            }
            Path.Segment newName = context.getValueFactories().getPathFactory().createSegment(name, nextIndex);
            node.setName(newName);
            parentNode.getChildren().add(node);
            parentNode.existingNames.add(name);
            return node;
        }

        public void moveNode(ExecutionContext context, InMemoryNode node, Name desiredNewName, Workspace newWorkspace, InMemoryNode newParent) {
            assert (context != null);
            assert (newParent != null);
            assert (node != null);
            assert (!newWorkspace.getRoot().equals(newParent));
            assert (!this.getRoot().equals(node));
            InMemoryNode oldParent = node.getParent();
            Name oldName = node.getName().getName();
            if (oldParent != null) {
                if (oldParent.equals(newParent)) {
                    return;
                }
                boolean removed = oldParent.getChildren().remove(node);
                assert (removed);
                node.setParent(null);
                this.correctSameNameSiblingIndexes(context, oldParent, oldName);
            }
            node.setParent(newParent);
            Name newName = oldName;
            if (desiredNewName != null) {
                newName = desiredNewName;
                node.setName(context.getValueFactories().getPathFactory().createSegment(desiredNewName, 1));
            }
            newParent.getChildren().add(node);
            this.correctSameNameSiblingIndexes(context, newParent, newName);
            if (!this.equals(newWorkspace)) {
                this.moveNodeToWorkspace(node, newWorkspace);
            }
        }

        protected void moveNodeToWorkspace(InMemoryNode node, Workspace newWorkspace) {
            assert (this.nodesByUuid.containsKey(node.getUuid()));
            assert (!newWorkspace.nodesByUuid.containsKey(node.getUuid()));
            this.nodesByUuid.remove(node.getUuid());
            newWorkspace.nodesByUuid.put(node.getUuid(), node);
            for (InMemoryNode child : node.getChildren()) {
                this.moveNodeToWorkspace(child, newWorkspace);
            }
        }

        public InMemoryNode copyNode(ExecutionContext context, InMemoryNode original, Workspace newWorkspace, InMemoryNode newParent, Name desiredName, boolean recursive, Map<UUID, UUID> oldToNewUuids) {
            assert (context != null);
            assert (original != null);
            assert (newParent != null);
            assert (newWorkspace != null);
            if (this.equals(newWorkspace) && oldToNewUuids == null) {
                oldToNewUuids = new HashMap<UUID, UUID>();
            }
            boolean reuseUuids = oldToNewUuids == null;
            Name childName = desiredName != null ? desiredName : original.getName().getName();
            UUID uuidForCopy = reuseUuids ? original.getUuid() : UUID.randomUUID();
            InMemoryNode copy = newWorkspace.createNode(context, newParent, childName, uuidForCopy);
            if (oldToNewUuids != null) {
                oldToNewUuids.put(original.getUuid(), copy.getUuid());
            }
            copy.getProperties().clear();
            copy.getProperties().putAll(original.getProperties());
            if (recursive) {
                for (InMemoryNode child : original.getChildren()) {
                    this.copyNode(context, child, newWorkspace, copy, null, true, oldToNewUuids);
                }
            }
            if (oldToNewUuids != null) {
                PropertyFactory propertyFactory = context.getPropertyFactory();
                UuidFactory uuidFactory = context.getValueFactories().getUuidFactory();
                ValueFactory<Reference> referenceFactory = context.getValueFactories().getReferenceFactory();
                for (Map.Entry<UUID, UUID> oldToNew : oldToNewUuids.entrySet()) {
                    InMemoryNode oldNode = this.getNode(oldToNew.getKey());
                    InMemoryNode newNode = newWorkspace.getNode(oldToNew.getValue());
                    assert (oldNode != null);
                    assert (newNode != null);
                    for (Map.Entry<Name, Property> entry : newNode.getProperties().entrySet()) {
                        Property property = entry.getValue();
                        ArrayList<Reference> newValues = new ArrayList<Reference>();
                        boolean foundReference = false;
                        Iterator<?> iter = property.getValues();
                        while (iter.hasNext()) {
                            Object value = iter.next();
                            PropertyType type = PropertyType.discoverType(value);
                            if (type == PropertyType.REFERENCE) {
                                UUID oldReferencedUuid = (UUID)uuidFactory.create(value);
                                UUID newReferencedUuid = oldToNewUuids.get(oldReferencedUuid);
                                if (newReferencedUuid == null) continue;
                                newValues.add(referenceFactory.create(newReferencedUuid));
                                foundReference = true;
                                continue;
                            }
                            newValues.add((Reference)value);
                        }
                        if (!foundReference) continue;
                        Property newProperty = propertyFactory.create(property.getName(), newValues);
                        entry.setValue(newProperty);
                    }
                }
            }
            return copy;
        }

        protected void correctSameNameSiblingIndexes(ExecutionContext context, InMemoryNode parentNode, Name name) {
            if (parentNode == null) {
                return;
            }
            LinkedList<InMemoryNode> childrenWithSameNames = new LinkedList<InMemoryNode>();
            for (InMemoryNode child : parentNode.getChildren()) {
                if (!child.getName().getName().equals(name)) continue;
                childrenWithSameNames.add(child);
            }
            if (childrenWithSameNames.size() == 0) {
                return;
            }
            if (childrenWithSameNames.size() == 1) {
                InMemoryNode childWithSameName = (InMemoryNode)childrenWithSameNames.get(0);
                Path.Segment newName = context.getValueFactories().getPathFactory().createSegment(name, 1);
                childWithSameName.setName(newName);
                return;
            }
            int index = 1;
            for (InMemoryNode childWithSameName : childrenWithSameNames) {
                Path.Segment segment = childWithSameName.getName();
                if (segment.getIndex() != index) {
                    Path.Segment newName = context.getValueFactories().getPathFactory().createSegment(name, index);
                    childWithSameName.setName(newName);
                }
                ++index;
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Workspace) {
                Workspace that = (Workspace)obj;
                return this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            return InMemoryRepository.this.getSourceName() + "/" + this.getName();
        }
    }
}

