/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.inmemory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.GuardedBy;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.RepositorySourceCapabilities;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepository;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepositoryConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryRepositorySource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final String DEFAULT_WORKSPACE_NAME = "";
    protected static final RepositorySourceCapabilities CAPABILITIES = new RepositorySourceCapabilities(true, true, false, true, true);
    protected static final String ROOT_NODE_UUID_ATTR = "rootNodeUuid";
    protected static final String SOURCE_NAME_ATTR = "sourceName";
    protected static final String DEFAULT_WORKSPACE_NAME_ATTR = "defaultWorkspaceName";
    protected static final String DEFAULT_CACHE_POLICY_ATTR = "defaultCachePolicy";
    protected static final String JNDI_NAME_ATTR = "jndiName";
    protected static final String RETRY_LIMIT_ATTR = "retryLimit";
    @GuardedBy(value="sourcesLock")
    private String name;
    @GuardedBy(value="this")
    private String jndiName;
    private String defaultWorkspaceName = "";
    private UUID rootNodeUuid = UUID.randomUUID();
    private CachePolicy defaultCachePolicy;
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    private transient InMemoryRepository repository;
    private transient RepositoryContext repositoryContext;

    @Override
    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    @Override
    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    @Override
    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        this.defaultCachePolicy = defaultCachePolicy;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspaceName;
    }

    public void setDefaultWorkspaceName(String defaultWorkspaceName) {
        this.defaultWorkspaceName = defaultWorkspaceName != null ? defaultWorkspaceName : DEFAULT_WORKSPACE_NAME;
    }

    public UUID getRootNodeUuid() {
        return this.rootNodeUuid;
    }

    public void setRootNodeUuid(UUID rootNodeUuid) {
        this.rootNodeUuid = rootNodeUuid != null ? rootNodeUuid : UUID.randomUUID();
    }

    public void setJndiName(String name) throws NamingException {
        this.setJndiName(name, null);
    }

    public synchronized void setJndiName(String name, Context context) throws NamingException {
        CheckArg.isNotNull((Object)name, (String)"name");
        if (context == null) {
            context = new InitialContext();
        }
        if (name != null) {
            context.bind(name, (Object)this);
        }
        if (this.jndiName != null && !this.jndiName.equals(name)) {
            context.unbind(this.jndiName);
        }
        this.jndiName = name;
    }

    public synchronized String getJndiName() {
        return this.jndiName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.repository == null) {
            this.repository = new InMemoryRepository(this.name, this.rootNodeUuid, this.defaultWorkspaceName);
        }
        return new InMemoryRepositoryConnection(this, this.repository);
    }

    @Override
    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME_ATTR, this.getName()));
        }
        if (this.getRootNodeUuid() != null) {
            ref.add(new StringRefAddr(ROOT_NODE_UUID_ATTR, this.getRootNodeUuid().toString()));
        }
        if (this.getJndiName() != null) {
            ref.add(new StringRefAddr(JNDI_NAME_ATTR, this.getJndiName()));
        }
        if (this.getDefaultWorkspaceName() != null) {
            ref.add(new StringRefAddr(DEFAULT_WORKSPACE_NAME_ATTR, this.getDefaultWorkspaceName()));
        }
        if (this.getDefaultCachePolicy() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(DEFAULT_CACHE_POLICY_ATTR, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = GraphI18n.errorSerializingInMemoryCachePolicyInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), e);
            }
        }
        ref.add(new StringRefAddr(RETRY_LIMIT_ATTR, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME_ATTR);
            String rootNodeUuidString = (String)values.get(ROOT_NODE_UUID_ATTR);
            String jndiName = (String)values.get(JNDI_NAME_ATTR);
            String defaultWorkspaceName = (String)values.get(DEFAULT_WORKSPACE_NAME_ATTR);
            Object defaultCachePolicy = values.get(DEFAULT_CACHE_POLICY_ATTR);
            String retryLimit = (String)values.get(RETRY_LIMIT_ATTR);
            InMemoryRepositorySource source = new InMemoryRepositorySource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuidString != null) {
                source.setRootNodeUuid(UUID.fromString(rootNodeUuidString));
            }
            if (defaultWorkspaceName != null) {
                source.setDefaultWorkspaceName(defaultWorkspaceName);
            }
            if (jndiName != null) {
                source.setJndiName(jndiName);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }

    @Override
    public RepositorySourceCapabilities getCapabilities() {
        return CAPABILITIES;
    }

    public String toString() {
        return "The \"" + this.name + "\" in-memory repository";
    }
}

