/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.mimetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.mimetype.MimeTypeDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ExtensionBasedMimeTypeDetector
implements MimeTypeDetector {
    public static final String MIME_TYPE_EXTENSIONS_RESOURCE_PATH = "/org/jboss/dna/graph/MimeTypes.properties";
    private final Map<String, String> mimeTypesByExtension;

    public ExtensionBasedMimeTypeDetector() {
        this(null, true);
    }

    public ExtensionBasedMimeTypeDetector(Map<String, String> extensionsToMimeTypes) {
        this(extensionsToMimeTypes, true);
    }

    public ExtensionBasedMimeTypeDetector(Map<String, String> extensionsToMimeTypes, boolean initWithDefaults) {
        Map<String, String> mappings = ExtensionBasedMimeTypeDetector.getDefaultMappings();
        if (extensionsToMimeTypes != null) {
            for (Map.Entry<String, String> entry : extensionsToMimeTypes.entrySet()) {
                String mimeType;
                String extensionString = entry.getKey();
                if (extensionString == null || (extensionString = extensionString.toLowerCase().trim().replaceAll("^.+", "")).length() == 0 || (mimeType = entry.getValue()) == null || (mimeType = entry.getValue().trim()).length() == 0) continue;
                assert (extensionString.length() != 0);
                assert (mimeType.length() != 0);
                mappings.put(extensionString, mimeType);
            }
        }
        HashMap<String, String> mappingsByAnyCharExtension = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String extensionString = entry.getKey();
            String mimeType = entry.getValue();
            assert (extensionString != null);
            assert (extensionString.length() != 0);
            assert (mimeType != null);
            assert (mimeType.length() != 0);
            mappingsByAnyCharExtension.put("." + extensionString, mimeType);
        }
        this.mimeTypesByExtension = Collections.unmodifiableMap(mappingsByAnyCharExtension);
    }

    protected static Map<String, String> getDefaultMappings() {
        Properties extensionsToMimeTypes = new Properties();
        try {
            extensionsToMimeTypes.load(ExtensionBasedMimeTypeDetector.class.getResourceAsStream(MIME_TYPE_EXTENSIONS_RESOURCE_PATH));
        }
        catch (IOException e) {
            I18n msg = GraphI18n.unableToAccessResourceFileFromClassLoader;
            Logger.getLogger(ExtensionBasedMimeTypeDetector.class).warn((Throwable)e, msg, new Object[]{MIME_TYPE_EXTENSIONS_RESOURCE_PATH});
        }
        HashMap<String, String> mimeTypesByExtension = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : extensionsToMimeTypes.entrySet()) {
            String mimeType = entry.getKey().toString().trim();
            String extensionStrings = entry.getValue().toString().toLowerCase().trim();
            for (String extensionString : extensionStrings.split("\\s+")) {
                if ((extensionString = extensionString.trim()).length() == 0) continue;
                mimeTypesByExtension.put(extensionString, mimeType);
            }
        }
        return mimeTypesByExtension;
    }

    @Override
    public String mimeTypeOf(String name, InputStream content) {
        if (name == null || name.length() == 0) {
            return null;
        }
        String trimmedName = name.trim();
        if (trimmedName.length() == 0) {
            return null;
        }
        int indexOfDelimiter = trimmedName.lastIndexOf(46);
        if (indexOfDelimiter < 1) {
            return null;
        }
        String extension = trimmedName.substring(indexOfDelimiter).toLowerCase();
        return this.mimeTypesByExtension.get(extension);
    }
}

