/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.property.basic;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.Path;

@Immutable
public class BasicPathSegment
implements Path.Segment {
    private static final long serialVersionUID = 4367349287846075157L;
    private final Name name;
    private final int index;

    public BasicPathSegment(Name name) {
        assert (name != null);
        this.name = name;
        this.index = 1;
    }

    public BasicPathSegment(Name name, int index) {
        assert (name != null);
        assert (index >= 1);
        this.name = name;
        this.index = this.isSelfReference() || this.isParentReference() ? 1 : index;
    }

    public int getIndex() {
        return this.index;
    }

    public Name getName() {
        return this.name;
    }

    public boolean hasIndex() {
        return this.index != 1;
    }

    public boolean isParentReference() {
        return this.name.getLocalName().equals("..") && this.name.getNamespaceUri().length() == 0;
    }

    public boolean isSelfReference() {
        return this.name.getLocalName().equals(".") && this.name.getNamespaceUri().length() == 0;
    }

    public int compareTo(Path.Segment that) {
        if (this == that) {
            return 0;
        }
        int diff = this.getName().compareTo(that.getName());
        if (diff != 0) {
            return diff;
        }
        return this.getIndex() - that.getIndex();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path.Segment) {
            Path.Segment that = (Path.Segment)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            return Math.abs(this.getIndex()) == Math.abs(that.getIndex());
        }
        return false;
    }

    public String toString() {
        if (this.hasIndex()) {
            return this.getName().toString() + "[" + this.getIndex() + "]";
        }
        return this.getName().toString();
    }

    public String getUnencodedString() {
        return this.getString(Path.NO_OP_ENCODER);
    }

    public String getString() {
        return this.getString(Path.DEFAULT_ENCODER);
    }

    public String getString(TextEncoder encoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        String encodedName = this.getName().getString(encoder);
        if (this.hasIndex()) {
            return encodedName + "[" + this.getIndex() + "]";
        }
        return encodedName;
    }

    public String getString(NamespaceRegistry namespaceRegistry) {
        return this.getString(namespaceRegistry, Path.DEFAULT_ENCODER);
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        return this.getString(namespaceRegistry, encoder, null);
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        String encodedName = this.getName().getString(namespaceRegistry, encoder, delimiterEncoder);
        if (this.hasIndex()) {
            return encodedName + "[" + this.getIndex() + "]";
        }
        return encodedName;
    }
}

