/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.Request;

public final class CloneWorkspaceRequest
extends Request {
    private static final long serialVersionUID = 1L;
    public static final CloneConflictBehavior DEFAULT_CLONE_CONFLICT_BEHAVIOR = CloneConflictBehavior.DO_NOT_CLONE;
    public static final CreateWorkspaceRequest.CreateConflictBehavior DEFAULT_CREATE_CONFLICT_BEHAVIOR = CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE;
    private final String nameOfWorkspaceToBeCloned;
    private final String desiredNameOfTargetWorkspace;
    private final CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior;
    private final CloneConflictBehavior cloneConflictBehavior;
    private String actualWorkspaceName;
    private Location actualLocationOfRoot;

    public CloneWorkspaceRequest(String nameOfWorkspaceToBeCloned, String desiredNameOfTargetWorkspace, CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior, CloneConflictBehavior cloneConflictBehavior) {
        CheckArg.isNotNull((Object)nameOfWorkspaceToBeCloned, (String)"nameOfWorkspaceToBeCloned");
        CheckArg.isNotNull((Object)desiredNameOfTargetWorkspace, (String)"desiredNameOfTargetWorkspace");
        this.nameOfWorkspaceToBeCloned = nameOfWorkspaceToBeCloned;
        this.desiredNameOfTargetWorkspace = desiredNameOfTargetWorkspace;
        this.createConflictBehavior = createConflictBehavior != null ? createConflictBehavior : DEFAULT_CREATE_CONFLICT_BEHAVIOR;
        this.cloneConflictBehavior = cloneConflictBehavior != null ? cloneConflictBehavior : DEFAULT_CLONE_CONFLICT_BEHAVIOR;
    }

    public String nameOfWorkspaceToBeCloned() {
        return this.nameOfWorkspaceToBeCloned;
    }

    public String desiredNameOfTargetWorkspace() {
        return this.desiredNameOfTargetWorkspace;
    }

    public CreateWorkspaceRequest.CreateConflictBehavior targetConflictBehavior() {
        return this.createConflictBehavior;
    }

    public CloneConflictBehavior cloneConflictBehavior() {
        return this.cloneConflictBehavior;
    }

    public String getActualWorkspaceName() {
        return this.actualWorkspaceName;
    }

    public void setActualWorkspaceName(String actualWorkspaceName) {
        this.actualWorkspaceName = actualWorkspaceName;
    }

    public Location getActualLocationOfRoot() {
        return this.actualLocationOfRoot;
    }

    public void setActualRootLocation(Location actualLocationOfRoot) {
        this.actualLocationOfRoot = actualLocationOfRoot;
    }

    public boolean isReadOnly() {
        return false;
    }

    public int hashCode() {
        return this.desiredNameOfTargetWorkspace.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CloneWorkspaceRequest that = (CloneWorkspaceRequest)obj;
            if (!this.nameOfWorkspaceToBeCloned.equals(that.nameOfWorkspaceToBeCloned())) {
                return false;
            }
            return this.desiredNameOfTargetWorkspace.equals(that.desiredNameOfTargetWorkspace());
        }
        return false;
    }

    public String toString() {
        return "clone workspace \"" + this.nameOfWorkspaceToBeCloned() + "\" as workspace \"" + this.desiredNameOfTargetWorkspace() + "\"";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CloneConflictBehavior {
        DO_NOT_CLONE,
        SKIP_CLONE;

    }
}

