/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.request.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeRequest
extends Request
implements Iterable<Request> {
    private static final long serialVersionUID = 1L;
    private final List<Request> requests;
    private final boolean readOnly;

    public static Request with(Request ... requests) {
        CheckArg.isNotEmpty((Object[])requests, (String)"requests");
        if (requests.length == 1) {
            CheckArg.isNotNull((Object)requests[0], (String)"requests[0]");
            return requests[0];
        }
        boolean readOnly = true;
        ArrayList<Request> list = new ArrayList<Request>(requests.length);
        for (Request request : requests) {
            if (request == null) continue;
            if (request instanceof CompositeRequest) {
                CompositeRequest composite = (CompositeRequest)request;
                list.addAll(composite.getRequests());
                if (composite.isReadOnly()) continue;
                readOnly = false;
                continue;
            }
            list.add(request);
            if (request.isReadOnly()) continue;
            readOnly = false;
        }
        CheckArg.isNotEmpty(list, (String)"requests");
        return new CompositeRequest(list, readOnly);
    }

    public static Request with(Iterator<? extends Request> requests) {
        CheckArg.isNotNull(requests, (String)"requests");
        boolean readOnly = true;
        LinkedList<Request> list = new LinkedList<Request>();
        while (requests.hasNext()) {
            Request request = requests.next();
            if (request == null) continue;
            if (request instanceof CompositeRequest) {
                CompositeRequest composite = (CompositeRequest)request;
                list.addAll(composite.getRequests());
                if (composite.isReadOnly()) continue;
                readOnly = false;
                continue;
            }
            list.add(request);
            if (request.isReadOnly()) continue;
            readOnly = false;
        }
        if (list.size() == 1) {
            return (Request)list.get(0);
        }
        CheckArg.isNotEmpty(list, (String)"requests");
        return new CompositeRequest(list, readOnly);
    }

    public static Request with(List<? extends Request> requests) {
        Request request;
        CheckArg.isNotEmpty(requests, (String)"requests");
        if (requests.size() == 1) {
            return requests.get(0);
        }
        boolean readOnly = true;
        Iterator<? extends Request> i$ = requests.iterator();
        while (i$.hasNext() && (readOnly = (request = i$.next()).isReadOnly())) {
        }
        return new CompositeRequest(requests, readOnly);
    }

    public static CompositeRequest add(CompositeRequest composite, Request ... requests) {
        CheckArg.isNotNull((Object)composite, (String)"composite");
        if (requests == null || requests.length == 0) {
            return composite;
        }
        ArrayList<Request> list = new ArrayList<Request>(requests.length + composite.size());
        boolean readOnly = composite.isReadOnly();
        if (composite.size() != 0) {
            list.addAll(composite.getRequests());
        }
        for (Request request : requests) {
            if (request == null) continue;
            if (request instanceof CompositeRequest) {
                CompositeRequest compositeRequest = (CompositeRequest)request;
                list.addAll(compositeRequest.getRequests());
                if (compositeRequest.isReadOnly()) continue;
                readOnly = false;
                continue;
            }
            list.add(request);
            if (request.isReadOnly()) continue;
            readOnly = false;
        }
        return new CompositeRequest(list, readOnly);
    }

    public static CompositeRequest add(CompositeRequest composite, Iterator<? extends Request> requests) {
        CheckArg.isNotNull((Object)composite, (String)"composite");
        LinkedList<Request> list = new LinkedList<Request>();
        boolean readOnly = composite.isReadOnly();
        if (composite.size() != 0) {
            list.addAll(composite.getRequests());
        }
        while (requests.hasNext()) {
            Request request = requests.next();
            if (request == null) continue;
            if (request instanceof CompositeRequest) {
                CompositeRequest compositeRequest = (CompositeRequest)request;
                list.addAll(compositeRequest.getRequests());
                if (compositeRequest.isReadOnly()) continue;
                readOnly = false;
                continue;
            }
            list.add(request);
            if (request.isReadOnly()) continue;
            readOnly = false;
        }
        return new CompositeRequest(list, readOnly);
    }

    CompositeRequest(List<? extends Request> requests, boolean readOnly) {
        AtomicBoolean flag = super.getCancelledFlag();
        for (Request request : requests) {
            request.setCancelledFlag(flag);
        }
        this.requests = Collections.unmodifiableList(requests);
        this.readOnly = readOnly;
    }

    public List<Request> getRequests() {
        return this.requests;
    }

    public int size() {
        return this.requests.size();
    }

    @Override
    public Iterator<Request> iterator() {
        return this.requests.iterator();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CompositeRequest) {
            CompositeRequest that = (CompositeRequest)obj;
            if (this.size() != that.size()) {
                return false;
            }
            Iterator<Request> thisIter = this.iterator();
            Iterator<Request> thatIter = that.iterator();
            while (thisIter.hasNext()) {
                Request thisRequest = thisIter.next();
                Request thatRequest = thatIter.next();
                if (!(thisRequest == null ? thatRequest != null : !thisRequest.equals(thatRequest))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

