/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.request.Request;

public final class CreateWorkspaceRequest
extends Request {
    private static final long serialVersionUID = 1L;
    public static final CreateConflictBehavior DEFAULT_CREATE_CONFLICT_BEHAVIOR = CreateConflictBehavior.DO_NOT_CREATE;
    private final String desiredNameOfNewWorkspace;
    private final CreateConflictBehavior createConflictBehavior;
    private String actualWorkspaceName;
    private Location actualLocationOfRoot;

    public CreateWorkspaceRequest(String desiredNameOfNewWorkspace, CreateConflictBehavior createConflictBehavior) {
        CheckArg.isNotNull((Object)desiredNameOfNewWorkspace, (String)"desiredNameOfNewWorkspace");
        this.desiredNameOfNewWorkspace = desiredNameOfNewWorkspace;
        this.createConflictBehavior = createConflictBehavior != null ? createConflictBehavior : DEFAULT_CREATE_CONFLICT_BEHAVIOR;
    }

    public String desiredNameOfNewWorkspace() {
        return this.desiredNameOfNewWorkspace;
    }

    public CreateConflictBehavior conflictBehavior() {
        return this.createConflictBehavior;
    }

    public String getActualWorkspaceName() {
        return this.actualWorkspaceName;
    }

    public void setActualWorkspaceName(String actualWorkspaceName) {
        this.actualWorkspaceName = actualWorkspaceName;
    }

    public Location getActualLocationOfRoot() {
        return this.actualLocationOfRoot;
    }

    public void setActualRootLocation(Location actualLocationOfRoot) {
        this.actualLocationOfRoot = actualLocationOfRoot;
    }

    public boolean isReadOnly() {
        return false;
    }

    public int hashCode() {
        return this.desiredNameOfNewWorkspace.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CreateWorkspaceRequest that = (CreateWorkspaceRequest)obj;
            return this.desiredNameOfNewWorkspace.equals(that.desiredNameOfNewWorkspace());
        }
        return false;
    }

    public String toString() {
        return "create new workspace \"" + this.desiredNameOfNewWorkspace() + "\"";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreateConflictBehavior {
        DO_NOT_CREATE,
        CREATE_WITH_ADJUSTED_NAME;

    }
}

