/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.NodeConflictBehavior;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.request.ChangeRequest;
import org.jboss.dna.graph.request.Request;

public class MoveBranchRequest
extends Request
implements ChangeRequest {
    private static final long serialVersionUID = 1L;
    public static final NodeConflictBehavior DEFAULT_CONFLICT_BEHAVIOR = NodeConflictBehavior.APPEND;
    private final Location from;
    private final Location into;
    private final String workspaceName;
    private final Name desiredNameForNode;
    private final NodeConflictBehavior conflictBehavior;
    private Location actualOldLocation;
    private Location actualNewLocation;

    public MoveBranchRequest(Location from, Location into, String workspaceName) {
        this(from, into, workspaceName, null, DEFAULT_CONFLICT_BEHAVIOR);
    }

    public MoveBranchRequest(Location from, Location into, String workspaceName, Name newNameForMovedNode) {
        this(from, into, workspaceName, newNameForMovedNode, DEFAULT_CONFLICT_BEHAVIOR);
    }

    public MoveBranchRequest(Location from, Location into, String workspaceName, NodeConflictBehavior conflictBehavior) {
        this(from, into, workspaceName, null, conflictBehavior);
    }

    public MoveBranchRequest(Location from, Location into, String workspaceName, Name newNameForMovedNode, NodeConflictBehavior conflictBehavior) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotNull((Object)into, (String)"into");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        this.from = from;
        this.into = into;
        this.workspaceName = workspaceName;
        this.desiredNameForNode = newNameForMovedNode;
        this.conflictBehavior = conflictBehavior;
    }

    public Location from() {
        return this.from;
    }

    public Location into() {
        return this.into;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name desiredName() {
        return this.desiredNameForNode;
    }

    public NodeConflictBehavior conflictBehavior() {
        return this.conflictBehavior;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean hasNoEffect() {
        if (this.into.hasPath() && !this.into.hasIdProperties() && this.from.hasPath()) {
            if (!this.from.getPath().getParent().equals(this.into.getPath())) {
                return false;
            }
            return this.desiredName() == null || this.desiredName().equals(this.from.getPath().getLastSegment().getName());
        }
        return false;
    }

    public void setActualLocations(Location oldLocation, Location newLocation) {
        Name expectedNewName;
        CheckArg.isNotNull((Object)oldLocation, (String)"oldLocation");
        CheckArg.isNotNull((Object)newLocation, (String)"newLocation");
        if (!this.from.isSame(oldLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{oldLocation, this.from}));
        }
        if (!oldLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{oldLocation}));
        }
        if (!newLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(new Object[]{newLocation}));
        }
        if (this.into().hasPath() && !newLocation.getPath().getParent().isSameAs(this.into.getPath())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{newLocation, this.into}));
        }
        Name actualNewName = newLocation.getPath().getLastSegment().getName();
        Name name = expectedNewName = this.desiredName() != null ? this.desiredName() : oldLocation.getPath().getLastSegment().getName();
        if (!actualNewName.equals(expectedNewName)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{newLocation, this.into}));
        }
        this.actualOldLocation = oldLocation;
        this.actualNewLocation = newLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualOldLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualNewLocation;
    }

    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && (this.into.hasPath() && this.into.getPath().isAtOrBelow(path) || this.from.hasPath() && this.from.getPath().isAtOrBelow(path));
    }

    public Location changedLocation() {
        return this.into;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            MoveBranchRequest that = (MoveBranchRequest)obj;
            if (!this.from().equals(that.from())) {
                return false;
            }
            if (!this.into().equals(that.into())) {
                return false;
            }
            if (!this.conflictBehavior().equals((Object)that.conflictBehavior())) {
                return false;
            }
            return this.workspaceName.equals(that.workspaceName);
        }
        return false;
    }

    public String toString() {
        if (this.desiredName() != null) {
            return "move branch " + this.from() + " in the \"" + this.inWorkspace() + "\" workspace into " + this.into() + " with name " + this.desiredName();
        }
        return "move branch " + this.from() + " in the \"" + this.inWorkspace() + "\" workspace into " + this.into();
    }
}

