/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.CacheableRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadAllPropertiesRequest
extends CacheableRequest
implements Iterable<Property> {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_NUMBER_OF_CHILDREN = -1;
    private final Location at;
    private final String workspaceName;
    private final Map<Name, Property> properties = new HashMap<Name, Property>();
    private int numberOfChildren = -1;
    private Location actualLocation;

    public ReadAllPropertiesRequest(Location at, String workspaceName) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Map<Name, Property> getPropertiesByName() {
        return this.properties;
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.getProperties().iterator();
    }

    public Property addProperty(Property property) {
        return this.properties.put(property.getName(), property);
    }

    public void addProperties(Property ... properties) {
        for (Property property : properties) {
            this.properties.put(property.getName(), property);
        }
    }

    public int getNumberOfChildren() {
        return this.numberOfChildren;
    }

    public void setNumberOfChildren(int numberOfChildren) {
        CheckArg.isNonNegative((int)numberOfChildren, (String)"numberOfChildren");
        this.numberOfChildren = numberOfChildren;
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.at.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.at}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadAllPropertiesRequest that = (ReadAllPropertiesRequest)obj;
            if (!this.at().equals(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "read properties of " + this.at() + " in the \"" + this.workspaceName + "\" workspace";
    }
}

