/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.ChangeRequest;
import org.jboss.dna.graph.request.Request;

public class SetPropertyRequest
extends Request
implements ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location on;
    private final String workspaceName;
    private final Property property;
    private Location actualLocation;

    public SetPropertyRequest(Location on, String workspaceName, Property property) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotNull((Object)property, (String)"property");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.on = on;
        this.property = property;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Location on() {
        return this.on;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Property property() {
        return this.property;
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.on.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.on}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.on.hasPath() && this.on.getPath().isAtOrBelow(path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            SetPropertyRequest that = (SetPropertyRequest)obj;
            if (!this.on().equals(that.on())) {
                return false;
            }
            if (!this.property().equals(that.property())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public Location changedLocation() {
        return this.on;
    }

    public String toString() {
        return "set property " + this.property().getName() + " on " + this.on() + " in the \"" + this.workspaceName + "\" workspace to " + this.property().getValuesAsArray();
    }
}

