/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import java.util.Collections;
import java.util.Map;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.ChangeRequest;
import org.jboss.dna.graph.request.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePropertiesRequest
extends Request
implements ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location on;
    private final String workspaceName;
    private final Map<Name, Property> properties;
    private Location actualLocation;

    public UpdatePropertiesRequest(Location on, String workspaceName, Map<Name, Property> properties) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotEmpty(properties, (String)"properties");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.on = on;
        this.properties = Collections.unmodifiableMap(properties);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Location on() {
        return this.on;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Map<Name, Property> properties() {
        return this.properties;
    }

    public void setActualLocationOfNode(Location actual) {
        if (!this.on.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.on}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.on.hasPath() && this.on.getPath().isAtOrBelow(path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            UpdatePropertiesRequest that = (UpdatePropertiesRequest)obj;
            if (!this.on().equals(that.on())) {
                return false;
            }
            if (!((Object)this.properties()).equals(that.properties())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    @Override
    public Location changedLocation() {
        return this.on;
    }

    public String toString() {
        return "update properties on " + this.on() + " in the \"" + this.workspaceName + "\" workspace to " + this.properties();
    }
}

