/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.sequencer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencerContext
extends ExecutionContext {
    private final Path inputPath;
    private final Map<Name, Property> inputPropertiesByName;
    private final Set<Property> inputProperties;
    private final Problems problems;
    private final String mimeType;

    public SequencerContext(ExecutionContext context, Path inputPath, Set<Property> inputProperties, String mimeType, Problems problems) {
        super(context);
        this.inputPath = inputPath;
        this.inputProperties = inputProperties != null ? new HashSet<Property>(inputProperties) : new HashSet();
        this.mimeType = mimeType;
        this.problems = problems != null ? problems : new SimpleProblems();
        HashMap<Name, Property> inputPropertiesByName = new HashMap<Name, Property>();
        for (Property property : this.inputProperties) {
            inputPropertiesByName.put(property.getName(), property);
        }
        this.inputPropertiesByName = Collections.unmodifiableMap(inputPropertiesByName);
    }

    public Path getInputPath() {
        return this.inputPath;
    }

    public Set<Property> getInputProperties() {
        return this.inputProperties;
    }

    public Property getInputProperty(Name name) {
        return this.inputPropertiesByName.get(name);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Problems getProblems() {
        return this.problems;
    }
}

