/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import javax.security.auth.login.LoginException;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.SecurityContext;
import org.jboss.dna.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.jboss.dna.graph.mimetype.MimeTypeDetector;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.property.ValueFactories;
import org.jboss.dna.graph.property.basic.BasicPropertyFactory;
import org.jboss.dna.graph.property.basic.SimpleNamespaceRegistry;
import org.jboss.dna.graph.property.basic.StandardValueFactories;
import org.jboss.dna.graph.property.basic.ThreadSafeNamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ExecutionContext
implements ClassLoaderFactory,
Cloneable {
    private final ClassLoaderFactory classLoaderFactory;
    private final PropertyFactory propertyFactory;
    private final ValueFactories valueFactories;
    private final NamespaceRegistry namespaceRegistry;
    private final MimeTypeDetector mimeTypeDetector;
    private final SecurityContext securityContext;

    public ExecutionContext() {
        this(new NullSecurityContext(), null, null, null, null, null);
        this.initializeDefaultNamespaces(this.getNamespaceRegistry());
        assert (this.securityContext != null);
    }

    protected ExecutionContext(ExecutionContext original) {
        CheckArg.isNotNull((Object)original, (String)"original");
        this.securityContext = original.getSecurityContext();
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
    }

    protected ExecutionContext(ExecutionContext original, SecurityContext securityContext) {
        CheckArg.isNotNull((Object)original, (String)"original");
        CheckArg.isNotNull((Object)securityContext, (String)"securityContext");
        this.securityContext = securityContext;
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
    }

    protected ExecutionContext(SecurityContext securityContext, NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory, MimeTypeDetector mimeTypeDetector, ClassLoaderFactory classLoaderFactory) {
        assert (securityContext != null);
        this.securityContext = securityContext;
        this.namespaceRegistry = namespaceRegistry != null ? namespaceRegistry : new ThreadSafeNamespaceRegistry(new SimpleNamespaceRegistry());
        this.valueFactories = valueFactories == null ? new StandardValueFactories(this.namespaceRegistry) : valueFactories;
        this.propertyFactory = propertyFactory == null ? new BasicPropertyFactory(this.valueFactories) : propertyFactory;
        this.classLoaderFactory = classLoaderFactory == null ? new StandardClassLoaderFactory() : classLoaderFactory;
        this.mimeTypeDetector = mimeTypeDetector != null ? mimeTypeDetector : new ExtensionBasedMimeTypeDetector();
    }

    protected ClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz);
    }

    public Logger getLogger(String name) {
        return Logger.getLogger((String)name);
    }

    public MimeTypeDetector getMimeTypeDetector() {
        return this.mimeTypeDetector;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    public ClassLoader getClassLoader(String ... classpath) {
        return this.classLoaderFactory.getClassLoader(classpath);
    }

    public ExecutionContext with(NamespaceRegistry namespaceRegistry) {
        return new ExecutionContext(this.getSecurityContext(), namespaceRegistry, null, null, this.getMimeTypeDetector(), this.getClassLoaderFactory());
    }

    public ExecutionContext with(MimeTypeDetector mimeTypeDetector) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), mimeTypeDetector, this.getClassLoaderFactory());
    }

    public ExecutionContext with(ClassLoaderFactory classLoaderFactory) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), classLoaderFactory);
    }

    public ExecutionContext with(SecurityContext securityContext) throws LoginException {
        return new ExecutionContext(this, securityContext);
    }

    public ExecutionContext clone() {
        return new ExecutionContext(this);
    }

    public String toString() {
        return "Execution context for " + this.getSecurityContext() == null ? "null" : this.getSecurityContext().getUserName();
    }

    protected void initializeDefaultNamespaces(NamespaceRegistry namespaceRegistry) {
        if (namespaceRegistry == null) {
            return;
        }
        namespaceRegistry.register("jcr", "http://www.jcp.org/jcr/1.0");
        namespaceRegistry.register("mix", "http://www.jcp.org/jcr/mix/1.0");
        namespaceRegistry.register("nt", "http://www.jcp.org/jcr/nt/1.0");
        namespaceRegistry.register("dna", "http://www.jboss.org/dna/1.0");
    }

    private static class NullSecurityContext
    implements SecurityContext {
        private NullSecurityContext() {
        }

        public String getUserName() {
            return null;
        }

        public boolean hasRole(String roleName) {
            return false;
        }

        public void logout() {
        }
    }
}

