/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.LocationWithPathAndProperty;
import org.jboss.dna.graph.LocationWithProperties;
import org.jboss.dna.graph.LocationWithUuid;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class LocationWithProperty
extends Location {
    protected final List<Property> idProperties;
    private final int hashCode;

    LocationWithProperty(Property idProperty) {
        assert (idProperty != null);
        assert (!idProperty.isEmpty());
        this.idProperties = Collections.singletonList(idProperty);
        this.hashCode = HashCode.compute((Object[])new Object[]{null, this.idProperties});
    }

    @Override
    public final Path getPath() {
        return null;
    }

    @Override
    public boolean hasPath() {
        return false;
    }

    @Override
    public final List<Property> getIdProperties() {
        return this.idProperties;
    }

    @Override
    public final boolean hasIdProperties() {
        return true;
    }

    @Override
    public final Property getIdProperty(Name name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        Property property = this.idProperties.get(0);
        return property.getName().equals(name) ? property : null;
    }

    @Override
    public UUID getUuid() {
        Property property = this.idProperties.get(0);
        if (DnaLexicon.UUID.equals(property.getName())) {
            Object value = property.getFirstValue();
            if (value instanceof UUID) {
                return (UUID)value;
            }
            if (value instanceof String) {
                return UUID.fromString((String)value);
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        Property idProperty = this.idProperties.get(0);
        if (newIdProperty.getName().equals(idProperty.getName())) {
            return Location.create(newIdProperty);
        }
        ArrayList<Property> newIdProperties = new ArrayList<Property>(this.idProperties.size() + 1);
        newIdProperties.add(newIdProperty);
        newIdProperties.addAll(this.idProperties);
        return new LocationWithProperties(newIdProperties);
    }

    @Override
    public Location with(Path newPath) {
        if (newPath == null) {
            return this;
        }
        Property idProperty = this.idProperties.get(0);
        return new LocationWithPathAndProperty(newPath, idProperty);
    }

    @Override
    public Location with(UUID uuid) {
        if (uuid == null) {
            return this;
        }
        Property idProperty = this.idProperties.get(0);
        if (DnaLexicon.UUID.equals(idProperty.getName())) {
            return new LocationWithUuid(uuid);
        }
        ArrayList<Property> newIdProperties = new ArrayList<Property>(this.idProperties.size() + 1);
        newIdProperties.add(new BasicSingleValueProperty(DnaLexicon.UUID, uuid));
        newIdProperties.addAll(this.idProperties);
        return new LocationWithProperties(newIdProperties);
    }
}

