/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.jboss.dna.common.statistic.Stopwatch;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.connector.federation.FederatedRepository;
import org.jboss.dna.graph.connector.federation.FederatedRequest;
import org.jboss.dna.graph.connector.federation.ForkRequestProcessor;
import org.jboss.dna.graph.connector.federation.JoinRequestProcessor;
import org.jboss.dna.graph.connector.federation.NoMoreFederatedRequests;
import org.jboss.dna.graph.observe.Observer;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.request.CompositeRequest;
import org.jboss.dna.graph.request.Request;

class FederatedRepositoryConnection
implements RepositoryConnection {
    private final FederatedRepository repository;
    private final Stopwatch stopwatch;
    private final Logger logger;
    private final Observer observer;

    FederatedRepositoryConnection(FederatedRepository repository, Observer observer) {
        this.repository = repository;
        this.logger = Logger.getLogger(this.getClass());
        this.stopwatch = this.logger.isTraceEnabled() ? new Stopwatch() : null;
        this.observer = observer;
    }

    FederatedRepository getRepository() {
        return this.repository;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.repository.getDefaultCachePolicy();
    }

    public String getSourceName() {
        return this.repository.getSourceName();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    protected boolean shouldProcessSynchronously(Request request) {
        if (request instanceof CompositeRequest) {
            CompositeRequest composite = (CompositeRequest)request;
            return composite.size() == 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ExecutionContext context, final Request request) throws RepositorySourceException {
        boolean abort;
        block20: {
            DateTime nowInUtc = context.getValueFactories().getDateFactory().createUtc();
            boolean synchronousStep1 = this.shouldProcessSynchronously(request);
            boolean awaitAllSubtasks = false;
            if (this.stopwatch != null) {
                this.stopwatch.start();
            }
            abort = false;
            try {
                try {
                    final LinkedBlockingQueue<FederatedRequest> requests = new LinkedBlockingQueue<FederatedRequest>();
                    final ForkRequestProcessor fork = new ForkRequestProcessor(this.repository, context, nowInUtc, requests);
                    if (synchronousStep1) {
                        try {
                            fork.process(request);
                            Object var10_13 = null;
                            fork.close();
                        }
                        catch (Throwable throwable) {
                            Object var10_14 = null;
                            fork.close();
                            throw throwable;
                        }
                        requests.add(new NoMoreFederatedRequests());
                    } else {
                        this.repository.getExecutor().submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    fork.process(request);
                                    Object var2_1 = null;
                                    fork.close();
                                }
                                catch (Throwable throwable) {
                                    Object var2_2 = null;
                                    fork.close();
                                    throw throwable;
                                }
                                requests.add(new NoMoreFederatedRequests());
                            }
                        });
                    }
                    JoinRequestProcessor join = new JoinRequestProcessor(this.repository, context, this.observer, nowInUtc);
                    try {
                        try {
                            join.process((BlockingQueue<FederatedRequest>)requests);
                        }
                        catch (RuntimeException e) {
                            abort = true;
                            throw e;
                        }
                        Object var12_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_19 = null;
                        join.close();
                        throw throwable;
                    }
                    join.close();
                    Object var14_21 = null;
                    if (this.stopwatch == null) break block20;
                }
                catch (InterruptedException e) {
                    abort = true;
                    request.setError(e);
                    Object var14_22 = null;
                    if (this.stopwatch != null) {
                        this.stopwatch.stop();
                    }
                    if (!abort) return;
                    return;
                }
                catch (ExecutionException e) {
                    abort = true;
                    request.setError(e);
                    Object var14_23 = null;
                    if (this.stopwatch != null) {
                        this.stopwatch.stop();
                    }
                    if (!abort) return;
                    return;
                }
                catch (CancellationException e) {
                    abort = true;
                    request.cancel();
                    Object var14_24 = null;
                    if (this.stopwatch != null) {
                        this.stopwatch.stop();
                    }
                    if (!abort) return;
                    return;
                }
                catch (RuntimeException e) {
                    abort = true;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var14_25 = null;
                if (this.stopwatch != null) {
                    this.stopwatch.stop();
                }
                if (!abort) throw throwable;
                throw throwable;
            }
            this.stopwatch.stop();
        }
        if (!abort) return;
    }

    public void close() {
        if (this.stopwatch != null) {
            this.logger.trace("Processing federated requests:\n" + this.stopwatch.getDetailedStatistics(), new Object[0]);
        }
    }
}

