/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.util.concurrent.CountDownLatch;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.graph.connector.federation.Projection;
import org.jboss.dna.graph.request.Request;

@NotThreadSafe
class FederatedRequest {
    private final Request original;
    private CountDownLatch forkLatch;
    private int incompleteCount;
    private ProjectedRequest first;

    FederatedRequest(Request original) {
        this.original = original;
    }

    public Request original() {
        return this.original;
    }

    public final FederatedRequest add(Request request, boolean isSameLocationAsOriginal, boolean isComplete, Projection projection, Projection secondProjection) {
        if (!isComplete) {
            ++this.incompleteCount;
        }
        if (this.first == null) {
            this.first = isSameLocationAsOriginal ? new MirrorRequest(request, isComplete, projection, secondProjection) : new ProjectedRequest(request, isComplete, projection, secondProjection);
        } else {
            this.first.addNext(request, isComplete, projection);
        }
        return this;
    }

    public final FederatedRequest add(Request request, boolean isSameLocationAsOriginal, boolean isComplete, Projection projection) {
        return this.add(request, isSameLocationAsOriginal, isComplete, projection, null);
    }

    public void freeze() {
        if (this.incompleteCount > 0 && this.forkLatch == null) {
            this.forkLatch = new CountDownLatch(this.incompleteCount);
        }
    }

    public ProjectedRequest getFirstProjectedRequest() {
        return this.first;
    }

    public boolean hasIncompleteRequests() {
        return this.incompleteCount != 0;
    }

    public CountDownLatch getLatch() {
        return this.forkLatch;
    }

    public void await() throws InterruptedException {
        if (this.forkLatch != null) {
            this.forkLatch.await();
        }
    }

    class MirrorRequest
    extends ProjectedRequest {
        protected MirrorRequest(Request request, boolean isComplete, Projection projection, Projection secondProjection) {
            super(request, isComplete, projection, secondProjection);
        }

        public boolean isSameLocation() {
            return true;
        }
    }

    class ProjectedRequest {
        private final Projection projection;
        private final Projection projection2;
        private final Request request;
        private final boolean isComplete;
        private ProjectedRequest next;

        protected ProjectedRequest(Request request, boolean isComplete, Projection projection, Projection secondProjection) {
            this.projection = projection;
            this.request = request;
            this.isComplete = isComplete;
            this.projection2 = secondProjection;
        }

        public Projection getProjection() {
            return this.projection;
        }

        public Projection getSecondProjection() {
            return this.projection2;
        }

        public Request getRequest() {
            return this.request;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public boolean isSameLocation() {
            return false;
        }

        public ProjectedRequest next() {
            return this.next;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        protected final ProjectedRequest addNext(Request request, boolean isComplete, Projection projection, Projection secondProjection) {
            ProjectedRequest last = this;
            while (last.next != null) {
                last = last.next;
            }
            last.next = new ProjectedRequest(request, isComplete, projection, secondProjection);
            return last.next;
        }

        protected final ProjectedRequest addNext(Request request, boolean isComplete, Projection projection) {
            return this.addNext(request, isComplete, projection, null);
        }
    }
}

