/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.ThreadSafeProblems;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.federation.BranchedMirrorProjector;
import org.jboss.dna.graph.connector.federation.GeneralProjector;
import org.jboss.dna.graph.connector.federation.MirrorProjector;
import org.jboss.dna.graph.connector.federation.OffsetMirrorProjector;
import org.jboss.dna.graph.connector.federation.ProjectedNode;
import org.jboss.dna.graph.connector.federation.Projection;
import org.jboss.dna.graph.connector.federation.Projector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class FederatedWorkspace {
    private final RepositoryContext repositoryContext;
    private final String sourceName;
    private final String workspaceName;
    private final List<Projection> projections;
    private final Map<String, List<Projection>> projectionsBySourceName;
    private final CachePolicy cachePolicy;
    private final Problems problems;
    private final Projector projector;

    public FederatedWorkspace(RepositoryContext repositoryContext, String sourceName, String workspaceName, Iterable<Projection> projections, CachePolicy cachePolicy) {
        CheckArg.isNotNull((Object)repositoryContext, (String)"repositoryContext");
        CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.repositoryContext = repositoryContext;
        this.workspaceName = workspaceName;
        this.sourceName = sourceName;
        this.cachePolicy = cachePolicy;
        this.problems = new ThreadSafeProblems();
        ArrayList<Projection> projectionList = new ArrayList<Projection>();
        for (Projection projection : projections) {
            if (projection == null || projectionList.contains(projection)) continue;
            projectionList.add(projection);
        }
        this.projections = Collections.unmodifiableList(projectionList);
        CheckArg.isNotEmpty(this.projections, (String)"sourceProjections");
        this.projectionsBySourceName = new HashMap<String, List<Projection>>();
        for (Projection projection : this.projections) {
            String nameOfSource = projection.getSourceName();
            List<Projection> projectionsForSource = this.projectionsBySourceName.get(nameOfSource);
            if (projectionsForSource == null) {
                projectionsForSource = new LinkedList<Projection>();
                this.projectionsBySourceName.put(nameOfSource, projectionsForSource);
            }
            projectionsForSource.add(projection);
        }
        ExecutionContext context = this.repositoryContext.getExecutionContext();
        Projector projector = MirrorProjector.with(context, projectionList);
        if (projector == null) {
            projector = BranchedMirrorProjector.with(context, projectionList);
        }
        if (projector == null) {
            projector = OffsetMirrorProjector.with(context, projectionList);
        }
        if (projector == null) {
            projector = GeneralProjector.with(context, projectionList);
        }
        assert (projector != null);
        this.projector = projector;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getName() {
        return this.workspaceName;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public Problems getProblems() {
        return this.problems;
    }

    public List<Projection> getProjections() {
        return this.projections;
    }

    public boolean contains(String sourceName, String workspaceName) {
        List<Projection> projections = this.projectionsBySourceName.get(sourceName);
        if (projections != null) {
            for (Projection projection : projections) {
                if (!projection.getWorkspaceName().equals(workspaceName)) continue;
                return true;
            }
        }
        return false;
    }

    Map<String, List<Projection>> getProjectionsBySourceName() {
        return this.projectionsBySourceName;
    }

    public ProjectedNode project(ExecutionContext context, Location location, boolean requiresUpdate) {
        return this.projector.project(context, location, requiresUpdate);
    }

    public int hashCode() {
        return this.workspaceName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FederatedWorkspace) {
            FederatedWorkspace that = (FederatedWorkspace)obj;
            if (!this.getSourceName().equals(that.getSourceName())) {
                return false;
            }
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            return ((Object)this.getProjections()).equals(that.getProjections());
        }
        return false;
    }
}

