/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.federation.FederatedRepository;
import org.jboss.dna.graph.connector.federation.FederatedRequest;
import org.jboss.dna.graph.connector.federation.FederatedWorkspace;
import org.jboss.dna.graph.connector.federation.PlaceholderNode;
import org.jboss.dna.graph.connector.federation.ProjectedNode;
import org.jboss.dna.graph.connector.federation.ProxyNode;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.ChangeRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CompositeRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DeleteChildrenRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidRequestException;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.ReadBranchRequest;
import org.jboss.dna.graph.request.ReadNodeRequest;
import org.jboss.dna.graph.request.ReadPropertyRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.SetPropertyRequest;
import org.jboss.dna.graph.request.UnsupportedRequestException;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyNodeExistsRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
class ForkRequestProcessor
extends RequestProcessor {
    private final FederatedRepository repository;
    private final ExecutorService executor;
    private final RepositoryConnectionFactory connectionFactory;
    private final Map<String, Channel> channelBySourceName = new HashMap<String, Channel>();
    private final Queue<FederatedRequest> federatedRequestQueue;

    public ForkRequestProcessor(FederatedRepository repository, ExecutionContext context, DateTime now, Queue<FederatedRequest> federatedRequestQueue) {
        super(repository.getSourceName(), context, null, now);
        this.repository = repository;
        this.executor = this.repository.getExecutor();
        this.connectionFactory = this.repository.getConnectionFactory();
        this.federatedRequestQueue = federatedRequestQueue;
        assert (this.executor != null);
        assert (this.connectionFactory != null);
        assert (this.federatedRequestQueue != null);
    }

    protected void submit(Request request, String sourceName) {
        assert (request != null);
        Channel channel = this.channelBySourceName.get(sourceName);
        if (channel == null) {
            channel = new Channel(sourceName);
            this.channelBySourceName.put(sourceName, channel);
            channel.start(this.executor, this.getExecutionContext(), this.connectionFactory);
        }
        channel.add(request);
    }

    protected void submitAndAwait(Request request, String sourceName) throws InterruptedException {
        assert (request != null);
        Channel channel = this.channelBySourceName.get(sourceName);
        if (channel == null) {
            channel = new Channel(sourceName);
            this.channelBySourceName.put(sourceName, channel);
            channel.start(this.executor, this.getExecutionContext(), this.connectionFactory);
        }
        channel.addAndAwait(request);
    }

    protected void submit(Request request, String sourceName, CountDownLatch latch) {
        assert (request != null);
        Channel channel = this.channelBySourceName.get(sourceName);
        if (channel == null) {
            channel = new Channel(sourceName);
            this.channelBySourceName.put(sourceName, channel);
            channel.start(this.executor, this.getExecutionContext(), this.connectionFactory);
        }
        channel.add(request, latch);
    }

    public void await() throws ExecutionException, InterruptedException, CancellationException {
        for (Channel channel : this.channelBySourceName.values()) {
            channel.await();
        }
    }

    protected final FederatedWorkspace getWorkspace(Request request, String workspaceName) {
        try {
            return this.repository.getWorkspace(workspaceName);
        }
        catch (InvalidWorkspaceException e) {
            request.setError(e);
        }
        catch (Throwable e) {
            request.setError(e);
        }
        return null;
    }

    protected final String readable(Location location) {
        return location.getString(this.getExecutionContext().getNamespaceRegistry());
    }

    protected final String readable(Name name) {
        return name.getString(this.getExecutionContext().getNamespaceRegistry());
    }

    protected final ProjectedNode project(Location location, String workspaceName, Request request, boolean requiresUpdate) {
        FederatedWorkspace workspace = this.getWorkspace(request, workspaceName);
        if (workspace == null) {
            return null;
        }
        ProjectedNode projectedNode = workspace.project(this.getExecutionContext(), location, requiresUpdate);
        if (projectedNode == null) {
            I18n msg = GraphI18n.locationCannotBeProjectedIntoWorkspaceAndSource;
            Path root = this.getExecutionContext().getValueFactories().getPathFactory().createRootPath();
            request.setError(new PathNotFoundException(location, root, msg.text(new Object[]{this.readable(location), workspace.getName(), this.repository.getSourceName()})));
        }
        return projectedNode;
    }

    protected void submit(FederatedRequest request) {
        request.freeze();
        if (request.hasIncompleteRequests()) {
            for (FederatedRequest.ProjectedRequest projected = request.getFirstProjectedRequest(); projected != null; projected = projected.next()) {
                if (projected.isComplete()) continue;
                this.submit(projected.getRequest(), projected.getProjection().getSourceName(), request.getLatch());
            }
        }
        this.federatedRequestQueue.add(request);
    }

    @Override
    protected void completeRequest(Request request) {
    }

    @Override
    public void process(VerifyNodeExistsRequest request) {
        ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, false);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        while (projectedNode != null) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                VerifyNodeExistsRequest placeholderRequest = new VerifyNodeExistsRequest(request.at(), request.inWorkspace());
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
            } else if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                VerifyNodeExistsRequest pushDownRequest = new VerifyNodeExistsRequest(proxy.location(), proxy.workspaceName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            projectedNode = projectedNode.next();
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadNodeRequest request) {
        ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, false);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        while (projectedNode != null) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                LinkedList<Location> children = new LinkedList<Location>();
                boolean firstRequest = true;
                for (ProjectedNode child : placeholder.children()) {
                    if (child.isPlaceholder()) {
                        children.add(child.location());
                        continue;
                    }
                    while (child != null && child.isProxy()) {
                        if (!children.isEmpty()) {
                            ReadNodeRequest placeholderRequest = new ReadNodeRequest(placeholder.location(), request.inWorkspace());
                            placeholderRequest.addChildren(children);
                            if (firstRequest) {
                                firstRequest = false;
                                placeholderRequest.addProperties(placeholder.properties().values());
                            }
                            placeholderRequest.setActualLocationOfNode(placeholder.location());
                            federatedRequest.add(placeholderRequest, true, true, null);
                            children = new LinkedList();
                        }
                        ProxyNode proxy = child.asProxy();
                        VerifyNodeExistsRequest verifyRequest = new VerifyNodeExistsRequest(proxy.location(), proxy.workspaceName());
                        federatedRequest.add(verifyRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                        child = child.next();
                    }
                }
                if (!children.isEmpty() || firstRequest) {
                    ReadNodeRequest placeholderRequest = new ReadNodeRequest(placeholder.location(), request.inWorkspace());
                    placeholderRequest.addChildren(children);
                    if (firstRequest) {
                        firstRequest = false;
                        placeholderRequest.addProperties(placeholder.properties().values());
                    }
                    placeholderRequest.setActualLocationOfNode(placeholder.location());
                    federatedRequest.add(placeholderRequest, true, true, null);
                }
            } else if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                ReadNodeRequest pushDownRequest = new ReadNodeRequest(proxy.location(), proxy.workspaceName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            projectedNode = projectedNode.next();
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadAllChildrenRequest request) {
        ProjectedNode projectedNode = this.project(request.of(), request.inWorkspace(), request, false);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        while (projectedNode != null) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                LinkedList<Location> children = new LinkedList<Location>();
                boolean firstRequest = true;
                for (ProjectedNode child : placeholder.children()) {
                    if (child.isPlaceholder()) {
                        children.add(child.location());
                        continue;
                    }
                    while (child != null && child.isProxy()) {
                        if (!children.isEmpty()) {
                            ReadAllChildrenRequest placeholderRequest = new ReadAllChildrenRequest(placeholder.location(), request.inWorkspace());
                            placeholderRequest.addChildren(children);
                            if (firstRequest) {
                                firstRequest = false;
                            }
                            placeholderRequest.setActualLocationOfNode(placeholder.location());
                            federatedRequest.add(placeholderRequest, true, true, null);
                            children = new LinkedList();
                        }
                        ProxyNode proxy = child.asProxy();
                        VerifyNodeExistsRequest verifyRequest = new VerifyNodeExistsRequest(proxy.location(), proxy.workspaceName());
                        federatedRequest.add(verifyRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                        child = child.next();
                    }
                }
                if (!children.isEmpty() || firstRequest) {
                    ReadAllChildrenRequest placeholderRequest = new ReadAllChildrenRequest(placeholder.location(), request.inWorkspace());
                    placeholderRequest.addChildren(children);
                    if (firstRequest) {
                        firstRequest = false;
                    }
                    placeholderRequest.setActualLocationOfNode(placeholder.location());
                    federatedRequest.add(placeholderRequest, true, true, null);
                }
            } else if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                ReadAllChildrenRequest pushDownRequest = new ReadAllChildrenRequest(proxy.location(), proxy.workspaceName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            projectedNode = projectedNode.next();
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadAllPropertiesRequest request) {
        ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, false);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        while (projectedNode != null) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                ReadAllPropertiesRequest placeholderRequest = new ReadAllPropertiesRequest(placeholder.location(), request.inWorkspace());
                placeholderRequest.addProperties(placeholder.properties().values());
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
            } else if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                ReadAllPropertiesRequest pushDownRequest = new ReadAllPropertiesRequest(proxy.location(), proxy.workspaceName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            projectedNode = projectedNode.next();
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadPropertyRequest request) {
        ProjectedNode projectedNode = this.project(request.on(), request.inWorkspace(), request, false);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        while (projectedNode != null) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                ReadPropertyRequest placeholderRequest = new ReadPropertyRequest(placeholder.location(), request.inWorkspace(), request.named());
                Property property = placeholder.properties().get(request.named());
                placeholderRequest.setProperty(property);
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
            } else if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                ReadPropertyRequest pushDownRequest = new ReadPropertyRequest(proxy.location(), proxy.workspaceName(), request.named());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            projectedNode = projectedNode.next();
        }
        this.submit(federatedRequest);
    }

    @Override
    public void process(ReadBranchRequest request) {
        ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, false);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        FederatedWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (request.maximumDepth() > 0) {
            this.processBranch(federatedRequest, projectedNode, workspace, request.maximumDepth());
        }
        this.submit(federatedRequest);
    }

    protected void processBranch(FederatedRequest federatedRequest, ProjectedNode projectedNode, FederatedWorkspace workspace, int maxDepth) {
        assert (maxDepth > 0);
        while (projectedNode != null) {
            if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                ReadNodeRequest placeholderRequest = new ReadNodeRequest(placeholder.location(), workspace.getName());
                ArrayList<Location> children = new ArrayList<Location>(placeholder.children().size());
                for (ProjectedNode child : placeholder.children()) {
                    children.add(child.location());
                }
                placeholderRequest.addChildren(children);
                placeholderRequest.addProperties(placeholder.properties().values());
                placeholderRequest.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(placeholderRequest, true, true, null);
                if (maxDepth > 1) {
                    for (ProjectedNode child : placeholder.children()) {
                        this.processBranch(federatedRequest, child, workspace, maxDepth - 1);
                    }
                }
            } else if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                ReadBranchRequest pushDownRequest = new ReadBranchRequest(proxy.location(), proxy.workspaceName(), maxDepth);
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            projectedNode = projectedNode.next();
        }
    }

    @Override
    public void process(CreateNodeRequest request) {
        ProjectedNode projectedNode = this.project(request.under(), request.inWorkspace(), request, true);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        PlaceholderNode placeholder = null;
        while (projectedNode != null) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                CreateNodeRequest pushDownRequest = new CreateNodeRequest(proxy.location(), proxy.workspaceName(), request.named(), request.conflictBehavior(), request.properties());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
            if (placeholder == null) {
                placeholder = projectedNode.asPlaceholder();
            }
            projectedNode = projectedNode.next();
        }
        if (placeholder != null) {
            switch (request.conflictBehavior()) {
                case UPDATE: 
                case DO_NOT_REPLACE: {
                    PathFactory pathFactory;
                    Path childPath;
                    Location childLocation;
                    Location parent = request.under();
                    if (!parent.hasPath() || (projectedNode = this.project(childLocation = Location.create(childPath = (pathFactory = this.getExecutionContext().getValueFactories().getPathFactory()).create(parent.getPath(), request.named())), request.inWorkspace(), request, true)) == null) break;
                    if (projectedNode.isProxy()) {
                        ProxyNode proxy = projectedNode.asProxy();
                        ReadNodeRequest pushDownRequest = new ReadNodeRequest(proxy.location(), proxy.workspaceName());
                        federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                        this.submit(federatedRequest);
                        return;
                    }
                    assert (projectedNode.isPlaceholder());
                    request.setActualLocationOfNode(projectedNode.location());
                    return;
                }
            }
        }
        String msg = GraphI18n.unableToCreateNodeUnderPlaceholder.text(new Object[]{this.readable(request.named()), this.readable(request.under()), request.inWorkspace(), this.getSourceName()});
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(UpdatePropertiesRequest request) {
        ProjectedNode projectedNode = this.project(request.on(), request.inWorkspace(), request, true);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        while (projectedNode != null) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                UpdatePropertiesRequest pushDownRequest = new UpdatePropertiesRequest(proxy.location(), proxy.workspaceName(), request.properties());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
            projectedNode = projectedNode.next();
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(new Object[]{this.readable(request.on()), request.inWorkspace(), this.getSourceName()});
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(SetPropertyRequest request) {
        ProjectedNode projectedNode = this.project(request.on(), request.inWorkspace(), request, true);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        while (projectedNode != null) {
            if (projectedNode.isProxy()) {
                ProxyNode proxy = projectedNode.asProxy();
                SetPropertyRequest pushDownRequest = new SetPropertyRequest(proxy.location(), proxy.workspaceName(), request.property());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                this.submit(federatedRequest);
                return;
            }
            assert (projectedNode.isPlaceholder());
            projectedNode = projectedNode.next();
        }
        String msg = GraphI18n.unableToUpdatePlaceholder.text(new Object[]{this.readable(request.on()), request.inWorkspace(), this.getSourceName()});
        request.setError(new UnsupportedRequestException(msg));
    }

    @Override
    public void process(DeleteBranchRequest request) {
        ProjectedNode projectedNode = this.project(request.at(), request.inWorkspace(), request, true);
        if (projectedNode == null) {
            return;
        }
        FederatedRequest federatedRequest = new FederatedRequest(request);
        FederatedWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        boolean submit = this.deleteBranch(federatedRequest, projectedNode, workspace, this.getExecutionContext());
        if (submit) {
            this.submit(federatedRequest);
        } else {
            String msg = GraphI18n.unableToDeletePlaceholder.text(new Object[]{this.readable(request.at()), request.inWorkspace(), this.getSourceName()});
            request.setError(new UnsupportedRequestException(msg));
        }
    }

    protected boolean deleteBranch(FederatedRequest federatedRequest, ProjectedNode projectedNode, FederatedWorkspace workspace, ExecutionContext context) {
        boolean submit = false;
        while (projectedNode != null) {
            if (projectedNode.isProxy()) {
                ChangeRequest pushDownRequest;
                ProxyNode proxy = projectedNode.asProxy();
                if (proxy.isTopLevelNode()) {
                    pushDownRequest = new DeleteChildrenRequest(proxy.location(), proxy.workspaceName());
                    federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                } else {
                    pushDownRequest = new DeleteBranchRequest(proxy.location(), proxy.workspaceName());
                    federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
                }
                submit = true;
            } else if (projectedNode.isPlaceholder()) {
                PlaceholderNode placeholder = projectedNode.asPlaceholder();
                DeleteBranchRequest delete = new DeleteBranchRequest(placeholder.location(), workspace.getName());
                delete.setActualLocationOfNode(placeholder.location());
                federatedRequest.add(delete, true, true, null);
                Iterator<ProjectedNode> i$ = placeholder.children().iterator();
                while (i$.hasNext()) {
                    for (ProjectedNode child = i$.next(); child != null && child.isProxy(); child = child.next()) {
                        submit = this.deleteBranch(federatedRequest, child.asProxy(), workspace, context);
                    }
                }
            }
            projectedNode = projectedNode.next();
        }
        return submit;
    }

    @Override
    public void process(CopyBranchRequest request) {
        ProxyNode intoProxy;
        ProxyNode fromProxy;
        ProjectedNode projectedFromNode = this.project(request.from(), request.fromWorkspace(), request, false);
        if (projectedFromNode == null) {
            return;
        }
        ProjectedNode projectedIntoNode = this.project(request.into(), request.intoWorkspace(), request, true);
        if (projectedIntoNode == null) {
            return;
        }
        while (projectedFromNode != null) {
            if (projectedFromNode.isProxy()) {
                fromProxy = projectedFromNode.asProxy();
                while (projectedIntoNode != null) {
                    if (projectedIntoNode.isProxy()) {
                        intoProxy = projectedIntoNode.asProxy();
                        if (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName())) break;
                    }
                    projectedIntoNode = projectedIntoNode.next();
                }
                if (projectedIntoNode != null) break;
            }
            projectedFromNode = projectedFromNode.next();
        }
        if (projectedFromNode == null || projectedIntoNode == null) {
            String msg = GraphI18n.copyLimitedToBeWithinSingleSource.text(new Object[]{this.readable(request.from()), request.fromWorkspace(), this.readable(request.into()), request.intoWorkspace(), this.getSourceName()});
            request.setError(new UnsupportedRequestException(msg));
            return;
        }
        fromProxy = projectedFromNode.asProxy();
        intoProxy = projectedIntoNode.asProxy();
        assert (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName()));
        boolean sameLocation = fromProxy.isSameLocationAsOriginal() && intoProxy.isSameLocationAsOriginal();
        CopyBranchRequest pushDown = new CopyBranchRequest(fromProxy.location(), fromProxy.workspaceName(), intoProxy.location(), intoProxy.workspaceName(), request.desiredName(), request.conflictBehavior());
        FederatedRequest federatedRequest = new FederatedRequest(request);
        federatedRequest.add(pushDown, sameLocation, false, fromProxy.projection(), intoProxy.projection());
        this.submit(federatedRequest);
    }

    @Override
    public void process(MoveBranchRequest request) {
        ProxyNode beforeProxy;
        ProxyNode intoProxy;
        ProxyNode fromProxy;
        ProjectedNode projectedBeforeNode;
        ProjectedNode projectedFromNode = this.project(request.from(), request.inWorkspace(), request, true);
        if (projectedFromNode == null) {
            return;
        }
        ProjectedNode projectedIntoNode = this.project(request.into(), request.inWorkspace(), request, true);
        if (projectedIntoNode == null) {
            return;
        }
        ProjectedNode projectedNode = projectedBeforeNode = request.before() != null ? this.project(request.before(), request.inWorkspace(), request, true) : null;
        while (projectedFromNode != null) {
            if (projectedFromNode.isProxy()) {
                fromProxy = projectedFromNode.asProxy();
                while (projectedIntoNode != null) {
                    if (projectedIntoNode.isProxy()) {
                        intoProxy = projectedIntoNode.asProxy();
                        if (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName())) break;
                    }
                    projectedIntoNode = projectedIntoNode.next();
                }
                if (projectedIntoNode != null) break;
            }
            projectedFromNode = projectedFromNode.next();
        }
        if (projectedFromNode == null || projectedIntoNode == null) {
            String msg = GraphI18n.moveLimitedToBeWithinSingleSource.text(new Object[]{this.readable(request.from()), request.inWorkspace(), this.readable(request.into()), request.inWorkspace(), this.getSourceName()});
            request.setError(new UnsupportedRequestException(msg));
            return;
        }
        fromProxy = projectedFromNode.asProxy();
        intoProxy = projectedIntoNode.asProxy();
        ProxyNode proxyNode = beforeProxy = request.before() != null ? projectedBeforeNode.asProxy() : null;
        assert (fromProxy.projection().getSourceName().equals(intoProxy.projection().getSourceName()));
        boolean sameLocation = fromProxy.isSameLocationAsOriginal() && intoProxy.isSameLocationAsOriginal();
        MoveBranchRequest pushDown = new MoveBranchRequest(fromProxy.location(), intoProxy.location(), beforeProxy.location(), intoProxy.workspaceName(), request.desiredName(), request.conflictBehavior());
        FederatedRequest federatedRequest = new FederatedRequest(request);
        federatedRequest.add(pushDown, sameLocation, false, fromProxy.projection(), intoProxy.projection());
        this.submit(federatedRequest);
    }

    @Override
    public void process(VerifyWorkspaceRequest request) {
        FederatedWorkspace workspace = this.getWorkspace(request, request.workspaceName());
        if (workspace != null) {
            ProjectedNode projectedNode;
            request.setActualWorkspaceName(workspace.getName());
            Location root = Location.create(this.getExecutionContext().getValueFactories().getPathFactory().createRootPath());
            if (projectedNode == null) {
                return;
            }
            FederatedRequest federatedRequest = new FederatedRequest(request);
            for (projectedNode = this.project(root, workspace.getName(), request, false); projectedNode != null; projectedNode = projectedNode.next()) {
                if (projectedNode.isPlaceholder()) {
                    PlaceholderNode placeholder = projectedNode.asPlaceholder();
                    VerifyNodeExistsRequest placeholderRequest = new VerifyNodeExistsRequest(root, workspace.getName());
                    placeholderRequest.setActualLocationOfNode(placeholder.location());
                    federatedRequest.add(placeholderRequest, true, true, null);
                    continue;
                }
                if (!projectedNode.isProxy()) continue;
                ProxyNode proxy = projectedNode.asProxy();
                VerifyNodeExistsRequest pushDownRequest = new VerifyNodeExistsRequest(proxy.location(), proxy.workspaceName());
                federatedRequest.add(pushDownRequest, proxy.isSameLocationAsOriginal(), false, proxy.projection());
            }
            this.submit(federatedRequest);
        }
    }

    @Override
    public void process(GetWorkspacesRequest request) {
        request.setAvailableWorkspaceNames(this.repository.getWorkspaceNames());
    }

    @Override
    public void process(CreateWorkspaceRequest request) {
        String msg = GraphI18n.federatedSourceDoesNotSupportCreatingWorkspaces.text(new Object[]{this.getSourceName()});
        request.setError(new InvalidRequestException(msg));
    }

    @Override
    public void process(CloneWorkspaceRequest request) {
        String msg = GraphI18n.federatedSourceDoesNotSupportCloningWorkspaces.text(new Object[]{this.getSourceName()});
        request.setError(new InvalidRequestException(msg));
    }

    @Override
    public void process(DestroyWorkspaceRequest request) {
        String msg = GraphI18n.federatedSourceDoesNotSupportDestroyingWorkspaces.text(new Object[]{this.getSourceName()});
        request.setError(new InvalidRequestException(msg));
    }

    @Override
    public void close() {
        super.close();
        for (Channel channel : this.channelBySourceName.values()) {
            channel.done();
        }
    }

    protected void cancel(boolean mayInterruptIfRunning) {
        for (Channel channel : this.channelBySourceName.values()) {
            channel.cancel(mayInterruptIfRunning);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Channel {
        protected final String sourceName;
        protected final LinkedList<Request> allRequests = new LinkedList();
        private final BlockingQueue<Request> queue = new LinkedBlockingQueue<Request>();
        protected final CompositeRequest composite;
        protected Future<String> future;
        protected final AtomicBoolean done = new AtomicBoolean(false);

        protected Channel(String sourceName) {
            assert (sourceName != null);
            this.sourceName = sourceName;
            this.composite = new CompositeRequest(false){
                private static final long serialVersionUID = 1L;
                private final LinkedList<Request> allRequests;
                {
                    this.allRequests = Channel.this.allRequests;
                }

                @Override
                public Iterator<Request> iterator() {
                    return Channel.this.createIterator();
                }

                @Override
                public List<Request> getRequests() {
                    return this.allRequests;
                }

                @Override
                public int size() {
                    return Channel.this.done.get() ? this.allRequests.size() : Integer.MAX_VALUE;
                }

                @Override
                public void cancel() {
                    Channel.this.done.set(true);
                }
            };
        }

        protected Iterator<Request> createIterator() {
            final BlockingQueue<Request> queue = this.queue;
            return new Iterator<Request>(){
                private BlockedRequest previousBlocked;
                private Request next;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    if (this.previousBlocked != null && this.previousBlocked.latch != null) {
                        this.previousBlocked.latch.countDown();
                    }
                    if (this.next != null) {
                        return true;
                    }
                    try {
                        this.next = (Request)queue.take();
                    }
                    catch (InterruptedException e) {
                        try {
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            Thread.interrupted();
                        }
                    }
                    if (this.next instanceof LastRequest) {
                        return false;
                    }
                    return this.next != null;
                }

                @Override
                public Request next() {
                    if (this.next == null) {
                        try {
                            this.next = (Request)queue.take();
                        }
                        catch (InterruptedException e) {
                            try {
                                throw new NoSuchElementException();
                            }
                            catch (Throwable throwable) {
                                Thread.interrupted();
                                throw throwable;
                            }
                        }
                    }
                    if (this.next instanceof BlockedRequest) {
                        this.previousBlocked = (BlockedRequest)this.next;
                        this.next = null;
                        return this.previousBlocked.original;
                    }
                    this.previousBlocked = null;
                    if (this.next != null) {
                        Request result = this.next;
                        this.next = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected void start(ExecutorService executor, final ExecutionContext context, final RepositoryConnectionFactory connectionFactory) {
            assert (executor != null);
            assert (context != null);
            assert (connectionFactory != null);
            if (this.future != null) {
                throw new IllegalStateException();
            }
            this.future = executor.submit(new Callable<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws Exception {
                    RepositoryConnection connection = connectionFactory.createConnection(Channel.this.sourceName);
                    assert (connection != null);
                    try {
                        connection.execute(context, Channel.this.composite);
                    }
                    finally {
                        connection.close();
                    }
                    return Channel.this.sourceName;
                }
            });
        }

        protected void add(Request request) {
            if (this.done.get()) {
                throw new IllegalStateException(GraphI18n.unableToAddRequestToChannelThatIsDone.text(new Object[]{this.sourceName, request}));
            }
            assert (request != null);
            this.allRequests.add(request);
            this.queue.add(request);
        }

        protected CountDownLatch add(Request request, CountDownLatch latch) {
            if (this.done.get()) {
                throw new IllegalStateException(GraphI18n.unableToAddRequestToChannelThatIsDone.text(new Object[]{this.sourceName, request}));
            }
            assert (request != null);
            assert (latch != null);
            this.allRequests.add(request);
            this.queue.add(new BlockedRequest(request, latch));
            return latch;
        }

        protected void addAndAwait(Request request) throws InterruptedException {
            this.add(request, new CountDownLatch(1)).await();
        }

        protected void done() {
            this.done.set(true);
            this.queue.add(new LastRequest());
        }

        protected boolean isDone() {
            return this.done.get();
        }

        public void cancel(boolean mayInterruptIfRunning) {
            if (this.future == null || this.future.isDone() || this.future.isCancelled()) {
                return;
            }
            this.composite.cancel();
            this.done();
            this.future.cancel(mayInterruptIfRunning);
        }

        public boolean isStarted() {
            return this.future != null;
        }

        public boolean isComplete() {
            return this.future != null && this.future.isDone();
        }

        protected void await() throws ExecutionException, InterruptedException, CancellationException {
            this.future.get();
        }

        protected List<Request> allRequests() {
            return this.allRequests;
        }

        protected String sourceName() {
            return this.sourceName;
        }
    }

    protected static class BlockedRequest
    extends Request {
        private static final long serialVersionUID = 1L;
        protected final Request original;
        protected final transient CountDownLatch latch;

        protected BlockedRequest(Request original, CountDownLatch latch) {
            this.original = original;
            this.latch = latch;
        }

        public boolean isReadOnly() {
            return this.original.isReadOnly();
        }

        public boolean isCancelled() {
            return this.original.isCancelled();
        }
    }

    protected static class LastRequest
    extends Request {
        private static final long serialVersionUID = 1L;

        protected LastRequest() {
        }

        public boolean isReadOnly() {
            return false;
        }
    }
}

