/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.federation.PlaceholderNode;
import org.jboss.dna.graph.connector.federation.ProjectedNode;
import org.jboss.dna.graph.connector.federation.Projection;
import org.jboss.dna.graph.connector.federation.ProjectorWithPlaceholders;
import org.jboss.dna.graph.connector.federation.ProxyNode;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class OffsetMirrorProjector
extends ProjectorWithPlaceholders {
    private final Projection projection;
    private final Path offset;
    private final int offsetSize;

    static OffsetMirrorProjector with(ExecutionContext context, List<Projection> projections) {
        assert (projections != null);
        assert (context != null);
        if (projections.size() != 1) {
            return null;
        }
        Projection projection = projections.get(0);
        assert (projection != null);
        if (projection.getRules().size() != 1) {
            return null;
        }
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        List<Path> topLevelPaths = projection.getRules().get(0).getTopLevelPathsInRepository(pathFactory);
        if (topLevelPaths.size() != 1) {
            return null;
        }
        Path topLevelPath = topLevelPaths.get(0);
        assert (topLevelPath != null);
        if (topLevelPath.isRoot()) {
            return null;
        }
        return new OffsetMirrorProjector(context, projections, topLevelPath);
    }

    private OffsetMirrorProjector(ExecutionContext context, List<Projection> projections, Path offset) {
        super(context, projections);
        this.projection = projections.get(0);
        this.offset = offset;
        this.offsetSize = offset.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProjectedNode project(ExecutionContext context, Location location, boolean requiresUpdate) {
        if (requiresUpdate && this.projection.isReadOnly()) {
            return null;
        }
        PlaceholderNode placeholder = this.isPlaceholder(location);
        if (placeholder != null) {
            return placeholder;
        }
        Path path = location.getPath();
        Location locationInSource = location;
        if (path == null) return new ProxyNode(this.projection, locationInSource, location);
        if (path.size() == this.offsetSize) {
            if (!path.equals(this.offset)) return null;
            locationInSource = location.with(context.getValueFactories().getPathFactory().createRootPath());
            return new ProxyNode(this.projection, locationInSource, location);
        } else {
            if (!path.isAtOrBelow(this.offset)) return null;
            locationInSource = location.with(path.subpath(this.offsetSize));
        }
        return new ProxyNode(this.projection, locationInSource, location);
    }
}

