/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.federation.PlaceholderNode;
import org.jboss.dna.graph.connector.federation.ProxyNode;

@NotThreadSafe
abstract class ProjectedNode {
    private final Location location;
    private ProjectedNode next;

    protected ProjectedNode(Location location) {
        this.location = location;
    }

    public Location location() {
        return this.location;
    }

    public int size() {
        return this.next != null ? this.next.size() + 1 : 1;
    }

    public int numberOfProxies() {
        int base = this.isProxy() ? 1 : 0;
        return this.next != null ? this.next.numberOfProxies() + base : base;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public ProjectedNode next() {
        return this.next;
    }

    void add(ProjectedNode next) {
        if (this.next != null) {
            this.next.add(next);
        } else {
            this.next = next;
        }
    }

    public abstract boolean isPlaceholder();

    public abstract boolean isProxy();

    public abstract PlaceholderNode asPlaceholder();

    public abstract ProxyNode asProxy();
}

