/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Projection
implements Comparable<Projection>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final List<Method> parserMethods = new CopyOnWriteArrayList<Method>();
    protected static final String PATH_RULE_PATTERN_STRING = "((?:[^=$]|=(?!>))+)(?:(?:=>((?:[^=$]|=(?!>))+))( \\$ (?:(?:[^=]|=(?!>))+))*)?";
    protected static final Pattern PATH_RULE_PATTERN;
    private final String sourceName;
    private final String workspaceName;
    private final List<Rule> rules;
    private final boolean simple;
    private final boolean readOnly;
    private final int hc;

    public static void addRuleParser(Method method) {
        if (method != null) {
            parserMethods.add(method);
        }
    }

    public static void addRuleParser(ClassLoader classLoader, String className, String methodName) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        CheckArg.isNotNull((Object)classLoader, (String)"classLoader");
        CheckArg.isNotEmpty((String)className, (String)"className");
        CheckArg.isNotEmpty((String)methodName, (String)"methodName");
        Class<?> clazz = Class.forName(className, true, classLoader);
        parserMethods.add(clazz.getMethod(className, String.class, ExecutionContext.class));
    }

    public static boolean removeRuleParser(Method method) {
        return parserMethods.remove(method);
    }

    public static boolean removeRuleParser(String declaringClassName, String methodName) {
        CheckArg.isNotEmpty((String)declaringClassName, (String)"declaringClassName");
        CheckArg.isNotEmpty((String)methodName, (String)"methodName");
        for (Method method : parserMethods) {
            if (!method.getName().equals(methodName) || !method.getDeclaringClass().getName().equals(declaringClassName)) continue;
            return parserMethods.remove(method);
        }
        return false;
    }

    public static Rule fromString(String definition, ExecutionContext context) {
        CheckArg.isNotNull((Object)context, (String)"env");
        String string = definition = definition != null ? definition.trim() : "";
        if (definition.length() == 0) {
            return null;
        }
        for (Method method : parserMethods) {
            try {
                Rule rule = (Rule)method.invoke(null, definition, context);
                if (rule == null) continue;
                return rule;
            }
            catch (Throwable err) {
                String msg = "Error while parsing project rule definition \"{0}\" using {1}";
                context.getLogger(Projection.class).trace(err, msg, new Object[]{definition, method});
            }
        }
        return null;
    }

    public static PathRule parsePathRule(String definition, ExecutionContext context) {
        String string = definition = definition != null ? definition.trim() : "";
        if (definition.length() == 0) {
            return null;
        }
        Matcher matcher = PATH_RULE_PATTERN.matcher(definition);
        if (!matcher.find()) {
            return null;
        }
        String reposPathStr = matcher.group(1);
        String sourcePathStr = matcher.group(2);
        if (reposPathStr == null || sourcePathStr == null) {
            return null;
        }
        reposPathStr = reposPathStr.trim();
        sourcePathStr = sourcePathStr.trim();
        if (reposPathStr.length() == 0 || sourcePathStr.length() == 0) {
            return null;
        }
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path repositoryPath = (Path)pathFactory.create(reposPathStr);
        Path sourcePath = (Path)pathFactory.create(sourcePathStr);
        LinkedList<Path> exceptions = new LinkedList<Path>();
        while (matcher.find()) {
            String exceptionStr = matcher.group(1);
            Path exception = (Path)pathFactory.create(exceptionStr);
            exceptions.add(exception);
        }
        return new PathRule(repositoryPath, sourcePath, exceptions);
    }

    public Projection(String sourceName, String workspaceName, boolean readOnly, Rule ... rules) {
        CheckArg.isNotEmpty((String)sourceName, (String)"sourceName");
        CheckArg.isNotEmpty((Object[])rules, (String)"rules");
        this.sourceName = sourceName;
        this.workspaceName = workspaceName;
        ArrayList<Rule> rulesList = new ArrayList<Rule>();
        for (Rule rule : rules) {
            if (rule == null) continue;
            rulesList.add(rule);
        }
        this.readOnly = readOnly;
        this.rules = Collections.unmodifiableList(rulesList);
        CheckArg.isNotEmpty(this.rules, (String)"rules");
        this.simple = this.computeSimpleProjection(this.rules);
        this.hc = HashCode.compute((Object[])new Object[]{this.sourceName, this.workspaceName});
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Set<Path> getPathsInSource(Path canonicalPathInRepository, PathFactory factory) {
        CheckArg.isNotNull((Object)factory, (String)"factory");
        assert (canonicalPathInRepository == null || canonicalPathInRepository.equals(canonicalPathInRepository.getCanonicalPath()));
        HashSet<Path> paths = new HashSet<Path>();
        for (Rule rule : this.getRules()) {
            Path pathInSource = rule.getPathInSource(canonicalPathInRepository, factory);
            if (pathInSource == null) continue;
            paths.add(pathInSource);
        }
        return paths;
    }

    public Set<Path> getPathsInRepository(Path canonicalPathInSource, PathFactory factory) {
        CheckArg.isNotNull((Object)factory, (String)"factory");
        assert (canonicalPathInSource == null || canonicalPathInSource.equals(canonicalPathInSource.getCanonicalPath()));
        HashSet<Path> paths = new HashSet<Path>();
        for (Rule rule : this.getRules()) {
            Path pathInRepository = rule.getPathInRepository(canonicalPathInSource, factory);
            if (pathInRepository == null) continue;
            paths.add(pathInRepository);
        }
        return paths;
    }

    public List<Path> getTopLevelPathsInRepository(PathFactory factory) {
        CheckArg.isNotNull((Object)factory, (String)"factory");
        List<Rule> rules = this.getRules();
        HashSet<Path> uniquePaths = new HashSet<Path>();
        ArrayList<Path> paths = new ArrayList<Path>(rules.size());
        for (Rule rule : this.getRules()) {
            for (Path path : rule.getTopLevelPathsInRepository(factory)) {
                if (uniquePaths.contains(path)) continue;
                paths.add(path);
                uniquePaths.add(path);
            }
        }
        return paths;
    }

    public boolean isTopLevelPath(Path repositoryPath) {
        for (Rule rule : this.getRules()) {
            if (!rule.isTopLevelPath(repositoryPath)) continue;
            return true;
        }
        return false;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected boolean computeSimpleProjection(List<Rule> rules) {
        HashSet<Path> repositoryPaths = new HashSet<Path>();
        for (Rule rule : rules) {
            if (rule instanceof PathRule) {
                PathRule pathRule = (PathRule)rule;
                Path repoPath = pathRule.getPathInRepository();
                if (!repositoryPaths.isEmpty()) {
                    if (repositoryPaths.contains(repoPath)) {
                        return false;
                    }
                    for (Path path : repositoryPaths) {
                        if (path.isAtOrAbove(repoPath)) {
                            return false;
                        }
                        if (!repoPath.isAtOrAbove(path)) continue;
                        return false;
                    }
                }
                repositoryPaths.add(repoPath);
                continue;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Projection) {
            Projection that = (Projection)obj;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            if (!this.getSourceName().equals(that.getSourceName())) {
                return false;
            }
            if (!this.getWorkspaceName().equals(that.getWorkspaceName())) {
                return false;
            }
            return ((Object)this.getRules()).equals(that.getRules());
        }
        return false;
    }

    @Override
    public int compareTo(Projection that) {
        if (this == that) {
            return 0;
        }
        int diff = this.getSourceName().compareTo(that.getSourceName());
        if (diff != 0) {
            return diff;
        }
        diff = this.getWorkspaceName().compareTo(that.getWorkspaceName());
        if (diff != 0) {
            return diff;
        }
        Iterator<Rule> thisIter = this.getRules().iterator();
        Iterator<Rule> thatIter = that.getRules().iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            diff = thisIter.next().compareTo(thatIter.next());
            if (diff == 0) continue;
            return diff;
        }
        if (thisIter.hasNext()) {
            return 1;
        }
        if (thatIter.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sourceName);
        sb.append("::");
        sb.append(this.workspaceName);
        sb.append(" { ");
        boolean first = true;
        for (Rule rule : this.getRules()) {
            if (!first) {
                sb.append(" ; ");
            }
            sb.append(rule.toString());
            first = false;
        }
        sb.append(" }");
        return sb.toString();
    }

    static {
        try {
            parserMethods.add(Projection.class.getDeclaredMethod("parsePathRule", String.class, ExecutionContext.class));
        }
        catch (Throwable err) {
            Logger.getLogger(Projection.class).error(err, GraphI18n.errorAddingProjectionRuleParseMethod, new Object[0]);
        }
        PATH_RULE_PATTERN = Pattern.compile(PATH_RULE_PATTERN_STRING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static class PathRule
    extends Rule {
        private final Path sourcePath;
        private final Path repositoryPath;
        private final List<Path> exceptions;
        private final int hc;
        private final List<Path> topLevelRepositoryPaths;

        public PathRule(Path repositoryPath, Path sourcePath) {
            this(repositoryPath, sourcePath, (Path[])null);
        }

        public PathRule(Path repositoryPath, Path sourcePath, Path ... exceptions) {
            CheckArg.isNotNull((Object)sourcePath, (String)"sourcePath");
            CheckArg.isNotNull((Object)repositoryPath, (String)"repositoryPath");
            this.sourcePath = sourcePath;
            this.repositoryPath = repositoryPath;
            if (exceptions == null || exceptions.length == 0) {
                this.exceptions = Collections.emptyList();
            } else {
                ArrayList<Path> exceptionList = new ArrayList<Path>();
                for (Path exception : exceptions) {
                    if (exception == null) continue;
                    exceptionList.add(exception);
                }
                this.exceptions = Collections.unmodifiableList(exceptionList);
            }
            this.hc = HashCode.compute((Object[])new Object[]{sourcePath, repositoryPath, exceptions});
            if (this.exceptions != null) {
                for (Path path : this.exceptions) {
                    if (!path.isAbsolute()) continue;
                    throw new IllegalArgumentException(GraphI18n.pathIsNotRelative.text(new Object[]{path}));
                }
            }
            this.topLevelRepositoryPaths = Collections.singletonList(this.getPathInRepository());
        }

        public PathRule(Path repositoryPath, Path sourcePath, List<Path> exceptions) {
            CheckArg.isNotNull((Object)sourcePath, (String)"sourcePath");
            CheckArg.isNotNull((Object)repositoryPath, (String)"repositoryPath");
            this.sourcePath = sourcePath;
            this.repositoryPath = repositoryPath;
            this.exceptions = exceptions == null || exceptions.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Path>(exceptions));
            this.hc = HashCode.compute((Object[])new Object[]{sourcePath, repositoryPath, exceptions});
            if (this.exceptions != null) {
                for (Path path : this.exceptions) {
                    if (!path.isAbsolute()) continue;
                    throw new IllegalArgumentException(GraphI18n.pathIsNotRelative.text(new Object[]{path}));
                }
            }
            this.topLevelRepositoryPaths = Collections.singletonList(this.getPathInRepository());
        }

        public Path getPathInRepository() {
            return this.repositoryPath;
        }

        public Path getPathInSource() {
            return this.sourcePath;
        }

        public boolean hasExceptionsToRule() {
            return this.exceptions.size() != 0;
        }

        public List<Path> getExceptionsToRule() {
            return this.exceptions;
        }

        protected boolean includes(Path pathInSource) {
            if (pathInSource != null && this.sourcePath.isAtOrAbove(pathInSource)) {
                Path subpathInSource;
                List<Path> exceptions = this.getExceptionsToRule();
                if (exceptions.size() != 0 && (subpathInSource = pathInSource.relativeTo(this.sourcePath)).size() != 0) {
                    for (Path exception : exceptions) {
                        if (!subpathInSource.isAtOrBelow(exception)) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public List<Path> getTopLevelPathsInRepository(PathFactory factory) {
            return this.topLevelRepositoryPaths;
        }

        @Override
        public boolean isTopLevelPath(Path path) {
            for (Path topLevel : this.topLevelRepositoryPaths) {
                if (!topLevel.equals(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Path getPathInSource(Path pathInRepository, PathFactory factory) {
            assert (pathInRepository.equals(pathInRepository.getCanonicalPath()));
            Path pathInSource = this.projectPathInRepositoryToPathInSource(pathInRepository, factory);
            return this.includes(pathInSource) ? pathInSource : null;
        }

        @Override
        public Path getPathInRepository(Path pathInSource, PathFactory factory) {
            assert (pathInSource.equals(pathInSource.getCanonicalPath()));
            if (!this.includes(pathInSource)) {
                return null;
            }
            return this.projectPathInSourceToPathInRepository(pathInSource, factory);
        }

        protected Path projectPathInSourceToPathInRepository(Path pathInSource, PathFactory factory) {
            if (!this.sourcePath.isAtOrAbove(pathInSource)) {
                return null;
            }
            Path relativeSourcePath = pathInSource.relativeTo(this.sourcePath);
            Path result = factory.create(this.repositoryPath, relativeSourcePath);
            return result.getNormalizedPath();
        }

        protected Path projectPathInRepositoryToPathInSource(Path pathInRepository, PathFactory factory) {
            if (!this.repositoryPath.isAtOrAbove(pathInRepository)) {
                return null;
            }
            Path pathInRegion = pathInRepository.relativeTo(this.repositoryPath);
            Path result = factory.create(this.sourcePath, pathInRegion);
            return result.getNormalizedPath();
        }

        @Override
        public String getString(NamespaceRegistry registry, TextEncoder encoder) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getPathInRepository().getString(registry, encoder));
            sb.append(" => ");
            sb.append(this.getPathInSource().getString(registry, encoder));
            if (this.getExceptionsToRule().size() != 0) {
                for (Path exception : this.getExceptionsToRule()) {
                    sb.append(" $ ");
                    sb.append(exception.getString(registry, encoder));
                }
            }
            return sb.toString();
        }

        @Override
        public String getString(TextEncoder encoder) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getPathInRepository().getString(encoder));
            sb.append(" => ");
            sb.append(this.getPathInSource().getString(encoder));
            if (this.getExceptionsToRule().size() != 0) {
                for (Path exception : this.getExceptionsToRule()) {
                    sb.append(" $ ");
                    sb.append(exception.getString(encoder));
                }
            }
            return sb.toString();
        }

        @Override
        public String getString() {
            return this.getString(Path.JSR283_ENCODER);
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PathRule) {
                PathRule that = (PathRule)obj;
                if (!this.getPathInRepository().equals(that.getPathInRepository())) {
                    return false;
                }
                if (!this.getPathInSource().equals(that.getPathInSource())) {
                    return false;
                }
                return ((Object)this.getExceptionsToRule()).equals(that.getExceptionsToRule());
            }
            return false;
        }

        @Override
        public int compareTo(Rule other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof PathRule) {
                PathRule that = (PathRule)other;
                int diff = this.getPathInRepository().compareTo(that.getPathInRepository());
                if (diff != 0) {
                    return diff;
                }
                diff = this.getPathInSource().compareTo(that.getPathInSource());
                if (diff != 0) {
                    return diff;
                }
                Iterator<Path> thisIter = this.getExceptionsToRule().iterator();
                Iterator<Path> thatIter = that.getExceptionsToRule().iterator();
                while (thisIter.hasNext() && thatIter.hasNext()) {
                    diff = thisIter.next().compareTo(thatIter.next());
                    if (diff == 0) continue;
                    return diff;
                }
                if (thisIter.hasNext()) {
                    return 1;
                }
                if (thatIter.hasNext()) {
                    return -1;
                }
                return 0;
            }
            return other.getClass().getName().compareTo(this.getClass().getName());
        }

        public String toString() {
            return this.getString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static abstract class Rule
    implements Comparable<Rule> {
        public abstract List<Path> getTopLevelPathsInRepository(PathFactory var1);

        public abstract boolean isTopLevelPath(Path var1);

        public abstract Path getPathInSource(Path var1, PathFactory var2);

        public abstract Path getPathInRepository(Path var1, PathFactory var2);

        public abstract String getString(NamespaceRegistry var1, TextEncoder var2);

        public abstract String getString(TextEncoder var1);

        public abstract String getString();
    }
}

