/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.federation.PlaceholderNode;
import org.jboss.dna.graph.connector.federation.ProjectedNode;
import org.jboss.dna.graph.connector.federation.Projection;
import org.jboss.dna.graph.connector.federation.Projector;
import org.jboss.dna.graph.connector.federation.ProxyNode;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
abstract class ProjectorWithPlaceholders
implements Projector {
    private Map<Path, PlaceholderNode> placeholderNodesByPath = new HashMap<Path, PlaceholderNode>();
    private Map<UUID, PlaceholderNode> placeholderNodesByUuid = new HashMap<UUID, PlaceholderNode>();

    ProjectorWithPlaceholders(ExecutionContext context, List<Projection> projections) {
        ArrayList<PlaceholderNode> placeholders = new ArrayList<PlaceholderNode>();
        ProjectorWithPlaceholders.loadPlaceholderNodes(context, projections, placeholders);
        for (PlaceholderNode placeholder : placeholders) {
            this.placeholderNodesByPath.put(placeholder.location().getPath(), placeholder);
            this.placeholderNodesByUuid.put(placeholder.location().getUuid(), placeholder);
        }
    }

    public PlaceholderNode isPlaceholder(Location location) {
        Path path = location.getPath();
        if (path != null) {
            return this.placeholderNodesByPath.get(path);
        }
        UUID uuid = location.getUuid();
        if (uuid != null) {
            return this.placeholderNodesByUuid.get(uuid);
        }
        return null;
    }

    protected static void loadPlaceholderNodes(ExecutionContext context, Iterable<Projection> projections, Collection<PlaceholderNode> placeholderNodes) {
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        HashMap<Path, ProxyNode> proxyNodesByPath = new HashMap<Path, ProxyNode>();
        HashMap<Path, PlaceholderNode> placeholdersByPath = new HashMap<Path, PlaceholderNode>();
        for (Projection projection : projections) {
            for (Path path : projection.getTopLevelPathsInRepository(pathFactory)) {
                if (path.isRoot()) continue;
                Location inRepository = Location.create(path);
                ProxyNode previous = null;
                for (Path pathInSource : projection.getPathsInSource(path, pathFactory)) {
                    Location inSource = Location.create(pathInSource);
                    ProxyNode proxy = new ProxyNode(projection, inSource, inRepository);
                    if (previous == null) {
                        previous = proxy;
                        proxyNodesByPath.put(path, proxy);
                        continue;
                    }
                    previous.add(proxy);
                }
                ProjectedNode child = previous;
                while (!path.isRoot()) {
                    Path parent = path.getParent();
                    PlaceholderNode parentPlaceholder = (PlaceholderNode)placeholdersByPath.get(parent);
                    if (parentPlaceholder == null) {
                        Map<Name, Property> properties = Collections.emptyMap();
                        Location location = Location.create(parent, UUID.randomUUID());
                        parentPlaceholder = new PlaceholderNode(location, properties, new ArrayList<ProjectedNode>());
                        placeholdersByPath.put(parent, parentPlaceholder);
                        placeholderNodes.add(parentPlaceholder);
                        parentPlaceholder.children().add(child);
                    } else {
                        List<ProjectedNode> children = parentPlaceholder.children();
                        if (!children.contains(child)) {
                            children.add(child);
                        }
                    }
                    child = parentPlaceholder;
                    path = parent;
                }
            }
        }
    }
}

