/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.federation.PlaceholderNode;
import org.jboss.dna.graph.connector.federation.ProjectedNode;
import org.jboss.dna.graph.connector.federation.Projection;

@NotThreadSafe
class ProxyNode
extends ProjectedNode {
    private final Projection projection;
    private final boolean sameLocationAsOriginal;
    private final Location federatedLocation;

    protected ProxyNode(Projection projection, Location locationInSource, Location locationInFederated) {
        super(locationInSource);
        this.projection = projection;
        this.federatedLocation = locationInFederated;
        this.sameLocationAsOriginal = locationInSource.equals(locationInFederated);
    }

    protected ProxyNode(Projection projection, Location locationInSource, Location locationInFederated, boolean isSameLocation) {
        super(locationInSource);
        this.projection = projection;
        this.federatedLocation = locationInFederated;
        this.sameLocationAsOriginal = isSameLocation;
    }

    public String source() {
        return this.projection.getSourceName();
    }

    public String workspaceName() {
        return this.projection.getWorkspaceName();
    }

    Projection projection() {
        return this.projection;
    }

    public Location federatedLocation() {
        return this.federatedLocation;
    }

    public boolean isPlaceholder() {
        return false;
    }

    public PlaceholderNode asPlaceholder() {
        return null;
    }

    public boolean isProxy() {
        return true;
    }

    public ProxyNode asProxy() {
        return this;
    }

    public boolean isTopLevelNode() {
        return this.federatedLocation != null && this.federatedLocation.hasPath() && this.projection.isTopLevelPath(this.federatedLocation.getPath());
    }

    public boolean isSameLocationAsOriginal() {
        return this.sameLocationAsOriginal;
    }
}

