/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.inmemory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class InMemoryNode {
    private final UUID uuid;
    private InMemoryNode parent;
    private Path.Segment name;
    private final Map<Name, Property> properties = new HashMap<Name, Property>();
    private final LinkedList<InMemoryNode> children = new LinkedList();
    final Set<Name> existingNames = new HashSet<Name>();

    public InMemoryNode(UUID uuid) {
        assert (uuid != null);
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Path.Segment getName() {
        return this.name;
    }

    protected void setName(Path.Segment name) {
        this.name = name;
    }

    public InMemoryNode getParent() {
        return this.parent;
    }

    protected void setParent(InMemoryNode parent) {
        this.parent = parent;
    }

    LinkedList<InMemoryNode> getChildren() {
        return this.children;
    }

    protected Map<Name, Property> getProperties() {
        return this.properties;
    }

    public InMemoryNode setProperty(Property property) {
        if (property != null) {
            this.properties.put(property.getName(), property);
        }
        return this;
    }

    public InMemoryNode setProperty(ExecutionContext context, String name, Object ... values) {
        PropertyFactory propertyFactory = context.getPropertyFactory();
        Name propertyName = (Name)context.getValueFactories().getNameFactory().create(name);
        return this.setProperty(propertyFactory.create(propertyName, values));
    }

    public Property getProperty(ExecutionContext context, String name) {
        Name propertyName = (Name)context.getValueFactories().getNameFactory().create(name);
        return this.getProperty(propertyName);
    }

    public Property getProperty(Name name) {
        return this.properties.get(name);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InMemoryNode) {
            InMemoryNode that = (InMemoryNode)obj;
            return this.getUuid().equals(that.getUuid());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name == null) {
            sb.append("");
        } else {
            sb.append(this.name);
        }
        sb.append(" (").append(this.uuid).append(")");
        return sb.toString();
    }
}

