/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.inmemory;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.transaction.xa.XAResource;
import org.jboss.dna.common.statistic.Stopwatch;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepository;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepositorySource;
import org.jboss.dna.graph.connector.inmemory.InMemoryRequestProcessor;
import org.jboss.dna.graph.request.Request;

public class InMemoryRepositoryConnection
implements RepositoryConnection {
    private final InMemoryRepositorySource source;
    private final InMemoryRepository repository;

    InMemoryRepositoryConnection(InMemoryRepositorySource source, InMemoryRepository repository) {
        assert (source != null);
        assert (repository != null);
        this.source = source;
        this.repository = repository;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.source.getDefaultCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        Logger logger = context.getLogger(this.getClass());
        Stopwatch sw = null;
        if (logger.isTraceEnabled()) {
            sw = new Stopwatch();
            sw.start();
        }
        InMemoryRequestProcessor processor = new InMemoryRequestProcessor(context, this.repository, this.source.getRepositoryContext());
        Lock lock = request.isReadOnly() ? this.repository.getLock().readLock() : this.repository.getLock().writeLock();
        lock.lock();
        try {
            processor.process(request);
        }
        finally {
            try {
                processor.close();
            }
            finally {
                lock.unlock();
            }
        }
        if (logger.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger.trace("InMemoryRepositoryConnection.execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }

    public String toString() {
        return "Connection to the \"" + this.getSourceName() + "\" in-memory repository";
    }
}

