/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.inmemory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.inmemory.InMemoryNode;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepository;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;

public class InMemoryRequestProcessor
extends RequestProcessor {
    private final PathFactory pathFactory;
    private final PropertyFactory propertyFactory;
    private final InMemoryRepository repository;

    protected InMemoryRequestProcessor(ExecutionContext context, InMemoryRepository repository, RepositoryContext repositoryContext) {
        super(repository.getSourceName(), context, repositoryContext != null ? repositoryContext.getObserver() : null);
        this.repository = repository;
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.propertyFactory = context.getPropertyFactory();
    }

    public void process(ReadAllChildrenRequest request) {
        InMemoryRepository.Workspace workspace = this.getWorkspace(request, request.inWorkspace());
        InMemoryNode node = this.getTargetNode(workspace, request, request.of());
        if (node == null) {
            return;
        }
        Location actualLocation = this.getActualLocation(request.of().getPath(), node);
        Path path = actualLocation.getPath();
        LinkedList<InMemoryNode> children = node.getChildren();
        for (InMemoryNode child : children) {
            Path.Segment childName = child.getName();
            Path childPath = this.pathFactory.create(path, childName);
            request.addChild(childPath, this.propertyFactory.create(DnaLexicon.UUID, child.getUuid()));
        }
        request.setActualLocationOfNode(actualLocation);
        this.setCacheableInfo(request);
    }

    public void process(ReadAllPropertiesRequest request) {
        InMemoryRepository.Workspace workspace = this.getWorkspace(request, request.inWorkspace());
        InMemoryNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        Location actualLocation = this.getActualLocation(request.at().getPath(), node);
        request.addProperty(this.propertyFactory.create(DnaLexicon.UUID, node.getUuid()));
        for (Property property : node.getProperties().values()) {
            request.addProperty(property);
        }
        request.setActualLocationOfNode(actualLocation);
        this.setCacheableInfo(request);
    }

    public void process(CopyBranchRequest request) {
        InMemoryRepository.Workspace workspace = this.getWorkspace(request, request.fromWorkspace());
        InMemoryRepository.Workspace newWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || newWorkspace == null) {
            return;
        }
        InMemoryNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        Path newParentPath = request.into().getPath();
        Name desiredName = request.desiredName();
        InMemoryNode newParent = newWorkspace.getNode(newParentPath);
        HashMap<UUID, UUID> copyMap = workspace.equals(newWorkspace) ? new HashMap<UUID, UUID>() : null;
        InMemoryNode newNode = workspace.copyNode(this.getExecutionContext(), node, newWorkspace, newParent, desiredName, true, copyMap);
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(newParentPath, newNode.getName());
        Location oldLocation = this.getActualLocation(request.from().getPath(), node);
        Location newLocation = Location.create(newPath, newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    public void process(CreateNodeRequest request) {
        InMemoryRepository.Workspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        Path parent = request.under().getPath();
        CheckArg.isNotNull((Object)parent, (String)"request.under().getPath()");
        InMemoryNode node = null;
        InMemoryNode parentNode = workspace.getNode(parent);
        if (parentNode == null) {
            Path lowestExisting = workspace.getLowestExistingPath(parent);
            request.setError(new PathNotFoundException(request.under(), lowestExisting, GraphI18n.inMemoryNodeDoesNotExist.text(new Object[]{parent})));
            return;
        }
        UUID uuid = null;
        for (Property property : request.properties()) {
            if (!property.getName().equals(DnaLexicon.UUID) && !property.getName().equals(JcrLexicon.UUID)) continue;
            uuid = (UUID)this.getExecutionContext().getValueFactories().getUuidFactory().create(property.getValues().next());
            break;
        }
        switch (request.conflictBehavior()) {
            case APPEND: 
            case DO_NOT_REPLACE: {
                node = workspace.createNode(this.getExecutionContext(), parentNode, request.named(), uuid);
                break;
            }
            case REPLACE: {
                node = this.getTargetNode(workspace, null, Location.create(this.pathFactory.create(parent, request.named()), uuid));
                if (node != null) {
                    workspace.removeNode(this.getExecutionContext(), node);
                }
                node = workspace.createNode(this.getExecutionContext(), parentNode, request.named(), uuid);
                break;
            }
            case UPDATE: {
                node = this.getTargetNode(workspace, null, Location.create(this.pathFactory.create(parent, request.named()), uuid));
                if (node != null) break;
                node = workspace.createNode(this.getExecutionContext(), parentNode, request.named(), uuid);
            }
        }
        assert (node != null);
        Path path = this.getExecutionContext().getValueFactories().getPathFactory().create(parent, node.getName());
        for (Property property : request.properties()) {
            Name propName = property.getName();
            if (property.size() == 0) {
                node.getProperties().remove(propName);
                continue;
            }
            if (propName.equals(DnaLexicon.UUID)) continue;
            node.getProperties().put(propName, property);
        }
        Location actualLocation = this.getActualLocation(path, node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    public void process(DeleteBranchRequest request) {
        InMemoryRepository.Workspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        InMemoryNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        workspace.removeNode(this.getExecutionContext(), node);
        Location actualLocation = this.getActualLocation(request.at().getPath(), node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    public void process(MoveBranchRequest request) {
        Path newParentPath;
        InMemoryRepository.Workspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        InMemoryNode beforeNode = request.before() != null ? this.getTargetNode(workspace, request, request.before()) : null;
        InMemoryNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (request.into() != null) {
            newParentPath = request.into().getPath();
        } else {
            assert (beforeNode != null);
            LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
            for (InMemoryNode current = beforeNode.getParent(); current != workspace.getRoot(); current = current.getParent()) {
                segments.addFirst(current.getName());
            }
            newParentPath = this.getExecutionContext().getValueFactories().getPathFactory().createAbsolutePath(segments);
        }
        InMemoryNode newParent = workspace.getNode(newParentPath);
        workspace.moveNode(this.getExecutionContext(), node, request.desiredName(), workspace, newParent, beforeNode);
        assert (node.getParent() == newParent);
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(newParentPath, node.getName());
        Location oldLocation = this.getActualLocation(request.from().getPath(), node);
        Location newLocation = Location.create(newPath, node.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    public void process(UpdatePropertiesRequest request) {
        InMemoryRepository.Workspace workspace = this.getWorkspace(request, request.inWorkspace());
        InMemoryNode node = this.getTargetNode(workspace, request, request.on());
        if (node == null) {
            return;
        }
        for (Map.Entry<Name, Property> propertyEntry : request.properties().entrySet()) {
            Property property = propertyEntry.getValue();
            if (property == null) {
                node.getProperties().remove(propertyEntry.getKey());
                continue;
            }
            Name propName = property.getName();
            if (propName.equals(DnaLexicon.UUID)) continue;
            node.getProperties().put(propName, property);
        }
        Location actualLocation = this.getActualLocation(request.on().getPath(), node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    public void process(CreateWorkspaceRequest request) {
        InMemoryRepository.Workspace workspace = this.repository.createWorkspace(this.getExecutionContext(), request.desiredNameOfNewWorkspace(), request.conflictBehavior());
        if (workspace == null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{request.desiredNameOfNewWorkspace(), this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        } else {
            InMemoryNode root = workspace.getRoot();
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
            request.setActualWorkspaceName(workspace.getName());
            this.recordChange(request);
        }
    }

    public void process(DestroyWorkspaceRequest request) {
        InMemoryRepository.Workspace workspace = this.repository.getWorkspace(this.getExecutionContext(), request.workspaceName());
        if (workspace != null) {
            InMemoryNode root = workspace.getRoot();
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
            this.recordChange(request);
        } else {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{request.workspaceName(), this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        }
    }

    public void process(GetWorkspacesRequest request) {
        Set<String> names = this.repository.getWorkspaceNames();
        request.setAvailableWorkspaceNames(new HashSet<String>(names));
        this.setCacheableInfo(request);
    }

    public void process(VerifyWorkspaceRequest request) {
        InMemoryRepository.Workspace original = this.getWorkspace(request, request.workspaceName());
        if (original != null) {
            Path path = this.getExecutionContext().getValueFactories().getPathFactory().createRootPath();
            request.setActualRootLocation(Location.create(path, original.getRoot().getUuid()));
            request.setActualWorkspaceName(original.getName());
        }
    }

    public void process(CloneWorkspaceRequest request) {
        ExecutionContext context = this.getExecutionContext();
        String targetWorkspaceName = request.desiredNameOfTargetWorkspace();
        String nameOfWorkspaceToBeCloned = request.nameOfWorkspaceToBeCloned();
        InMemoryRepository.Workspace original = this.repository.getWorkspace(context, nameOfWorkspaceToBeCloned);
        InMemoryRepository.Workspace target = this.repository.getWorkspace(context, targetWorkspaceName);
        if (original == null) {
            switch (request.cloneConflictBehavior()) {
                case DO_NOT_CLONE: {
                    String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{nameOfWorkspaceToBeCloned, this.repository.getSourceName()});
                    request.setError(new InvalidWorkspaceException(msg));
                    return;
                }
                case SKIP_CLONE: {
                    target = this.repository.createWorkspace(context, targetWorkspaceName, request.targetConflictBehavior());
                    if (target == null) {
                        String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{targetWorkspaceName, this.repository.getSourceName()});
                        request.setError(new InvalidWorkspaceException(msg));
                    } else {
                        InMemoryNode root = target.getRoot();
                        request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
                        request.setActualWorkspaceName(target.getName());
                    }
                    return;
                }
            }
        }
        assert (original != null);
        target = this.repository.createWorkspace(context, targetWorkspaceName, request.targetConflictBehavior(), nameOfWorkspaceToBeCloned);
        if (target == null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{targetWorkspaceName, this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        } else {
            InMemoryNode root = target.getRoot();
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
            request.setActualWorkspaceName(target.getName());
            this.recordChange(request);
        }
    }

    protected Location getActualLocation(Path path, InMemoryNode node) {
        if (path == null) {
            LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
            for (InMemoryNode n = node; n != null && n.getParent() != null; n = n.getParent()) {
                segments.addFirst(n.getName());
            }
            path = this.pathFactory.createAbsolutePath(segments);
        }
        return Location.create(path, node.getUuid());
    }

    protected InMemoryRepository.Workspace getWorkspace(Request request, String workspaceName) {
        InMemoryRepository.Workspace workspace = this.repository.getWorkspace(this.getExecutionContext(), workspaceName);
        if (workspace == null) {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{workspaceName, this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        }
        return workspace;
    }

    protected InMemoryNode getTargetNode(InMemoryRepository.Workspace workspace, Request request, Location location) {
        if (workspace == null) {
            return null;
        }
        InMemoryNode node = null;
        UUID uuid = location.getUuid();
        if (uuid != null) {
            node = workspace.getNode(uuid);
        }
        Path path = null;
        if (node == null && (path = location.getPath()) != null) {
            node = workspace.getNode(path);
        }
        if (node == null && request != null) {
            if (path == null) {
                if (uuid == null) {
                    I18n msg = GraphI18n.inMemoryConnectorRequestsMustHavePathOrUuid;
                    request.setError(new IllegalArgumentException(msg.text(new Object[0])));
                    return null;
                }
                request.setError(new PathNotFoundException(location, this.pathFactory.createRootPath(), GraphI18n.inMemoryNodeDoesNotExist.text(new Object[]{path})));
                return null;
            }
            Path lowestExisting = workspace.getLowestExistingPath(path);
            request.setError(new PathNotFoundException(location, lowestExisting, GraphI18n.inMemoryNodeDoesNotExist.text(new Object[]{path})));
        }
        return node;
    }
}

