/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.io;

import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.NodeConflictBehavior;
import org.jboss.dna.graph.io.Destination;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class GraphBatchDestination
implements Destination {
    protected final Graph.Batch batch;
    protected final boolean ignoreSubmit;

    public GraphBatchDestination(Graph.Batch batch) {
        this(batch, false);
    }

    public GraphBatchDestination(Graph.Batch batch, boolean ignoreSubmit) {
        assert (batch != null);
        this.batch = batch;
        this.ignoreSubmit = ignoreSubmit;
    }

    public boolean isSubmitIgnored() {
        return this.ignoreSubmit;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.batch.getGraph().getContext();
    }

    @Override
    public void create(Path path, List<Property> properties) {
        assert (properties != null);
        Graph.Create<Graph.Batch> create = null;
        create = properties.isEmpty() ? this.batch.create(path) : this.batch.create(path, properties);
        assert (create != null);
        NodeConflictBehavior behavior = this.createBehaviorFor(path);
        if (behavior != null) {
            switch (behavior) {
                case APPEND: {
                    create.byAppending();
                    break;
                }
                case REPLACE: {
                    create.orReplace();
                    break;
                }
                case UPDATE: {
                    create.byAppending();
                    break;
                }
                case DO_NOT_REPLACE: {
                    create.byAppending();
                }
            }
        }
        create.and();
    }

    @Override
    public void create(Path path, Property firstProperty, Property ... additionalProperties) {
        Graph.Create<Graph.Batch> create = null;
        create = firstProperty == null ? this.batch.create(path) : this.batch.create(path, firstProperty, additionalProperties);
        assert (create != null);
        NodeConflictBehavior behavior = this.createBehaviorFor(path);
        if (behavior != null) {
            switch (behavior) {
                case APPEND: {
                    create.byAppending();
                    break;
                }
                case REPLACE: {
                    create.orReplace();
                    break;
                }
                case UPDATE: {
                    create.byAppending();
                    break;
                }
                case DO_NOT_REPLACE: {
                    create.byAppending();
                }
            }
        }
        create.and();
    }

    @Override
    public void setProperties(Path path, Property ... properties) {
        if (properties == null) {
            return;
        }
        this.batch.set(properties).on(path);
    }

    @Override
    public void submit() {
        if (!this.ignoreSubmit && !this.batch.hasExecuted()) {
            this.batch.execute();
        }
    }

    protected NodeConflictBehavior createBehaviorFor(Path path) {
        return null;
    }
}

