/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.observe;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.observe.ChangeObserver;
import org.jboss.dna.graph.observe.Changes;
import org.jboss.dna.graph.observe.Observable;

@ThreadSafe
public class ChangeObservers
implements Observable {
    private final CopyOnWriteArrayList<ObserverReference> observers = new CopyOnWriteArrayList();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public boolean register(ChangeObserver observer) {
        if (observer != null && !this.shutdown.get() && this.observers.addIfAbsent(new ObserverReference(observer))) {
            observer.registeredWith(this);
            return true;
        }
        return false;
    }

    public boolean unregister(ChangeObserver observer) {
        if (observer != null && this.observers.remove(observer)) {
            observer.unregisteredWith(this);
            return true;
        }
        return false;
    }

    public void shutdown() {
        this.shutdown.set(true);
        while (!this.observers.isEmpty()) {
            Iterator<ObserverReference> iter = this.observers.iterator();
            this.observers.clear();
            while (iter.hasNext()) {
                ObserverReference reference = iter.next();
                if (reference.get() == null) continue;
                ((ChangeObserver)reference.get()).unregisteredWith(this);
            }
        }
    }

    public boolean isEmpty() {
        return this.observers.isEmpty();
    }

    public void broadcast(Changes changes) {
        CheckArg.isNotNull((Object)changes, (String)"changes");
        for (ObserverReference observerReference : this.observers) {
            ChangeObserver observer = (ChangeObserver)observerReference.get();
            if (observer == null) {
                this.observers.remove(observerReference);
                continue;
            }
            try {
                observer.notify(changes);
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).debug(t, "Exception while notifying", new Object[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ObserverReference
    extends WeakReference<ChangeObserver> {
        final int hc;

        protected ObserverReference(ChangeObserver source) {
            super(source);
            this.hc = source.hashCode();
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObserverReference) {
                ChangeObserver thatSource;
                ObserverReference that = (ObserverReference)obj;
                ChangeObserver thisSource = (ChangeObserver)this.get();
                return thisSource == (thatSource = (ChangeObserver)that.get());
            }
            if (obj instanceof ChangeObserver) {
                ChangeObserver that = (ChangeObserver)obj;
                return this.get() == that;
            }
            return false;
        }
    }
}

