/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.observe;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.observe.ChangeObserver;
import org.jboss.dna.graph.observe.Changes;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.ChangeRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DeleteChildrenRequest;
import org.jboss.dna.graph.request.RemovePropertyRequest;
import org.jboss.dna.graph.request.SetPropertyRequest;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;

public abstract class NetChangeObserver
extends ChangeObserver {
    protected NetChangeObserver() {
    }

    public void notify(Changes changes) {
        HashMap detailsByLocationByWorkspace = new HashMap();
        for (ChangeRequest change : changes) {
            Location location = change.changedLocation();
            String workspace = change.changedWorkspace();
            TreeMap<Location, NetChangeDetails> detailsByLocation = (TreeMap<Location, NetChangeDetails>)detailsByLocationByWorkspace.get(workspace);
            NetChangeDetails details = null;
            if (detailsByLocation == null) {
                detailsByLocation = new TreeMap<Location, NetChangeDetails>();
                detailsByLocationByWorkspace.put(workspace, detailsByLocation);
                details = new NetChangeDetails();
                detailsByLocation.put(location, details);
            } else {
                details = (NetChangeDetails)detailsByLocation.get(location);
                if (details == null) {
                    details = new NetChangeDetails();
                    detailsByLocation.put(location, details);
                }
            }
            if (change instanceof CreateNodeRequest) {
                CreateNodeRequest create = (CreateNodeRequest)change;
                details.addEventType(ChangeType.NODE_ADDED);
                for (Property property : create) {
                    details.addProperty(property);
                }
                continue;
            }
            if (change instanceof UpdatePropertiesRequest) {
                UpdatePropertiesRequest update = (UpdatePropertiesRequest)change;
                for (Map.Entry entry : update.properties().entrySet()) {
                    Property property = (Property)entry.getValue();
                    if (property != null) {
                        details.changeProperty(property);
                        continue;
                    }
                    details.removeProperty((Name)entry.getKey());
                }
                continue;
            }
            if (change instanceof SetPropertyRequest) {
                SetPropertyRequest set = (SetPropertyRequest)change;
                details.changeProperty(set.property());
                continue;
            }
            if (change instanceof RemovePropertyRequest) {
                RemovePropertyRequest remove = (RemovePropertyRequest)change;
                details.removeProperty(remove.propertyName());
                continue;
            }
            if (change instanceof DeleteBranchRequest) {
                details.addEventType(ChangeType.NODE_REMOVED);
                continue;
            }
            if (!(change instanceof DeleteChildrenRequest)) continue;
            DeleteChildrenRequest delete = (DeleteChildrenRequest)change;
            for (Location location2 : delete.getActualChildrenDeleted()) {
                NetChangeDetails childDetails = (NetChangeDetails)detailsByLocation.get(location);
                if (childDetails == null) {
                    childDetails = new NetChangeDetails();
                    detailsByLocation.put(location2, childDetails);
                }
                childDetails.addEventType(ChangeType.NODE_REMOVED);
            }
        }
        String sourceName = changes.getSourceName();
        for (Map.Entry byWorkspaceEntry : detailsByLocationByWorkspace.entrySet()) {
            String workspaceName = (String)byWorkspaceEntry.getKey();
            for (Map.Entry entry : ((Map)byWorkspaceEntry.getValue()).entrySet()) {
                Location location = (Location)entry.getKey();
                NetChangeDetails details = (NetChangeDetails)entry.getValue();
                this.notify(new NetChange(sourceName, workspaceName, location, details.getEventTypes(), details.getModifiedProperties(), details.getRemovedProperties()));
            }
        }
    }

    protected abstract void notify(NetChange var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    private static class NetChangeDetails {
        private final Set<Property> modifiedProperties = new HashSet<Property>();
        private final Set<Name> removedProperties = new HashSet<Name>();
        private EnumSet<ChangeType> eventTypes = EnumSet.noneOf(ChangeType.class);

        protected NetChangeDetails() {
        }

        public void addEventType(ChangeType eventType) {
            this.eventTypes.add(eventType);
        }

        public void addProperty(Property property) {
            this.modifiedProperties.add(property);
            this.eventTypes.add(ChangeType.PROPERTY_ADDED);
        }

        public void changeProperty(Property property) {
            this.modifiedProperties.add(property);
            this.eventTypes.add(ChangeType.PROPERTY_CHANGED);
        }

        public void removeProperty(Name propertyName) {
            this.removedProperties.add(propertyName);
            this.eventTypes.add(ChangeType.PROPERTY_REMOVED);
        }

        public EnumSet<ChangeType> getEventTypes() {
            return this.eventTypes;
        }

        public Set<Property> getModifiedProperties() {
            return this.modifiedProperties;
        }

        public Set<Name> getRemovedProperties() {
            return this.removedProperties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static class NetChange {
        private final String sourceName;
        private final String workspaceName;
        private final Location location;
        private final EnumSet<ChangeType> eventTypes;
        private final Set<Property> modifiedProperties;
        private final Set<Name> removedProperties;
        private final int hc;

        public NetChange(String sourceName, String workspaceName, Location location, EnumSet<ChangeType> eventTypes, Set<Property> modifiedProperties, Set<Name> removedProperties) {
            assert (sourceName != null);
            assert (workspaceName != null);
            assert (location != null);
            this.sourceName = sourceName;
            this.workspaceName = workspaceName;
            this.location = location;
            this.hc = HashCode.compute((Object[])new Object[]{this.workspaceName, this.location});
            this.eventTypes = eventTypes;
            if (modifiedProperties == null) {
                modifiedProperties = Collections.emptySet();
            }
            if (removedProperties == null) {
                removedProperties = Collections.emptySet();
            }
            this.modifiedProperties = Collections.unmodifiableSet(modifiedProperties);
            this.removedProperties = Collections.unmodifiableSet(removedProperties);
        }

        public Path getPath() {
            return this.location.getPath();
        }

        public String getRepositorySourceName() {
            return this.sourceName;
        }

        public String getRepositoryWorkspaceName() {
            return this.workspaceName;
        }

        public Set<Property> getModifiedProperties() {
            return this.modifiedProperties;
        }

        public Set<Name> getRemovedProperties() {
            return this.removedProperties;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean includesAll(ChangeType ... jcrEventTypes) {
            for (ChangeType jcrEventType : jcrEventTypes) {
                if (this.eventTypes.contains((Object)jcrEventType)) continue;
                return false;
            }
            return true;
        }

        public boolean includes(ChangeType ... jcrEventTypes) {
            for (ChangeType jcrEventType : jcrEventTypes) {
                if (!this.eventTypes.contains((Object)jcrEventType)) continue;
                return true;
            }
            return false;
        }

        public boolean is(ChangeType jcrEventTypes) {
            return this.eventTypes.contains((Object)jcrEventTypes);
        }

        public boolean isSameNode(NetChange that) {
            if (that == this) {
                return true;
            }
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.workspaceName.equals(that.workspaceName)) {
                return false;
            }
            return this.location.equals(that.location);
        }

        public boolean isPropertyModified(String property) {
            return this.modifiedProperties.contains(property);
        }

        public boolean isPropertyRemoved(String property) {
            return this.removedProperties.contains(property);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NetChange) {
                NetChange that = (NetChange)obj;
                if (!this.isSameNode(that)) {
                    return false;
                }
                return this.eventTypes == that.eventTypes;
            }
            return false;
        }

        public String toString() {
            return this.workspaceName + "=>" + this.location;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        NODE_ADDED,
        NODE_REMOVED,
        PROPERTY_ADDED,
        PROPERTY_REMOVED,
        PROPERTY_CHANGED;

    }
}

