/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.property.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.property.PropertyType;
import org.jboss.dna.graph.property.ValueFactories;
import org.jboss.dna.graph.property.ValueFactory;
import org.jboss.dna.graph.property.basic.BasicEmptyProperty;
import org.jboss.dna.graph.property.basic.BasicMultiValueProperty;
import org.jboss.dna.graph.property.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPropertyFactory
implements PropertyFactory {
    private final ValueFactories factories;

    public BasicPropertyFactory(ValueFactories valueFactories) {
        CheckArg.isNotNull((Object)valueFactories, (String)"value factories");
        this.factories = valueFactories;
    }

    @Override
    public Property create(Name name, Iterable<?> values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name, Iterator<?> values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name, Object ... values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Object ... values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        if (values == null || values.length == 0) {
            return new BasicEmptyProperty(name);
        }
        int len = values.length;
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        if (values.length == 1) {
            Object value = values[0];
            if (value instanceof Collection) {
                return this.create(name, (Collection)value);
            }
            value = factory.create(values[0]);
            return new BasicSingleValueProperty(name, value);
        }
        ArrayList<Object> valueList = new ArrayList<Object>(len);
        for (int i = 0; i != len; ++i) {
            Object value = factory.create(values[i]);
            valueList.add(value);
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Iterable<?> values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        ArrayList<Object> valueList = null;
        if (values instanceof Collection) {
            Collection originalValues = (Collection)values;
            if (originalValues.isEmpty()) {
                return new BasicEmptyProperty(name);
            }
            valueList = new ArrayList(originalValues.size());
        } else {
            valueList = new ArrayList<Object>();
        }
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        for (Object value : values) {
            valueList.add(factory.create(value));
        }
        if (valueList.isEmpty()) {
            return new BasicEmptyProperty(name);
        }
        if (valueList.size() == 1) {
            return new BasicSingleValueProperty(name, valueList.get(0));
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Iterator<?> values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        while (values.hasNext()) {
            Object value = values.next();
            value = factory.create(value);
            valueList.add(value);
        }
        if (valueList.isEmpty()) {
            return new BasicEmptyProperty(name);
        }
        if (valueList.size() == 1) {
            return new BasicSingleValueProperty(name, valueList.get(0));
        }
        return new BasicMultiValueProperty(name, valueList);
    }
}

