/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.property.basic;

import java.math.BigDecimal;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.property.BinaryFactory;
import org.jboss.dna.graph.property.DateTimeFactory;
import org.jboss.dna.graph.property.NameFactory;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PropertyType;
import org.jboss.dna.graph.property.Reference;
import org.jboss.dna.graph.property.UuidFactory;
import org.jboss.dna.graph.property.ValueFactory;
import org.jboss.dna.graph.property.basic.AbstractValueFactories;
import org.jboss.dna.graph.property.basic.BooleanValueFactory;
import org.jboss.dna.graph.property.basic.DecimalValueFactory;
import org.jboss.dna.graph.property.basic.DoubleValueFactory;
import org.jboss.dna.graph.property.basic.InMemoryBinaryValueFactory;
import org.jboss.dna.graph.property.basic.JodaDateTimeValueFactory;
import org.jboss.dna.graph.property.basic.LongValueFactory;
import org.jboss.dna.graph.property.basic.NameValueFactory;
import org.jboss.dna.graph.property.basic.ObjectValueFactory;
import org.jboss.dna.graph.property.basic.PathValueFactory;
import org.jboss.dna.graph.property.basic.StringValueFactory;
import org.jboss.dna.graph.property.basic.UriValueFactory;
import org.jboss.dna.graph.property.basic.UuidReferenceValueFactory;
import org.jboss.dna.graph.property.basic.UuidValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class StandardValueFactories
extends AbstractValueFactories {
    private final ValueFactory<String> stringFactory;
    private final BinaryFactory binaryFactory;
    private final ValueFactory<Boolean> booleanFactory;
    private final DateTimeFactory dateFactory;
    private final ValueFactory<BigDecimal> decimalFactory;
    private final ValueFactory<Double> doubleFactory;
    private final ValueFactory<Long> longFactory;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final ValueFactory<Reference> referenceFactory;
    private final ValueFactory<URI> uriFactory;
    private final UuidFactory uuidFactory;
    private final ValueFactory<Object> objectFactory;
    private final NamespaceRegistry namespaceRegistry;
    private final TextDecoder decoder;
    private final TextEncoder encoder;

    public StandardValueFactories(NamespaceRegistry namespaceRegistry) {
        this(namespaceRegistry, null, null, new ValueFactory[0]);
    }

    public StandardValueFactories(NamespaceRegistry namespaceRegistry, TextDecoder decoder, TextEncoder encoder, ValueFactory<?> ... extraFactories) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        this.namespaceRegistry = namespaceRegistry;
        this.decoder = decoder != null ? decoder : ValueFactory.DEFAULT_DECODER;
        this.encoder = encoder != null ? encoder : ValueFactory.DEFAULT_ENCODER;
        HashMap factories = new HashMap();
        for (ValueFactory<?> factory : extraFactories) {
            if (factory == null) continue;
            factories.put(factory.getPropertyType(), factory);
        }
        this.stringFactory = StandardValueFactories.getFactory(factories, new StringValueFactory(this.namespaceRegistry, this.decoder, this.encoder));
        StringValueFactory stringFactoryWithoutNamespaces = new StringValueFactory(this.decoder, this.encoder);
        this.binaryFactory = (BinaryFactory)StandardValueFactories.getFactory(factories, new InMemoryBinaryValueFactory(this.decoder, stringFactoryWithoutNamespaces));
        this.booleanFactory = StandardValueFactories.getFactory(factories, new BooleanValueFactory(this.decoder, this.stringFactory));
        this.dateFactory = (DateTimeFactory)StandardValueFactories.getFactory(factories, new JodaDateTimeValueFactory(this.decoder, this.stringFactory));
        this.decimalFactory = StandardValueFactories.getFactory(factories, new DecimalValueFactory(this.decoder, this.stringFactory));
        this.doubleFactory = StandardValueFactories.getFactory(factories, new DoubleValueFactory(this.decoder, this.stringFactory));
        this.longFactory = StandardValueFactories.getFactory(factories, new LongValueFactory(this.decoder, this.stringFactory));
        this.nameFactory = (NameFactory)StandardValueFactories.getFactory(factories, new NameValueFactory(this.namespaceRegistry, this.decoder, this.stringFactory));
        this.pathFactory = (PathFactory)StandardValueFactories.getFactory(factories, new PathValueFactory(this.decoder, this.stringFactory, this.nameFactory));
        this.referenceFactory = StandardValueFactories.getFactory(factories, new UuidReferenceValueFactory(this.decoder, this.stringFactory));
        this.uuidFactory = (UuidFactory)StandardValueFactories.getFactory(factories, new UuidValueFactory(this.decoder, this.stringFactory));
        this.uriFactory = StandardValueFactories.getFactory(factories, new UriValueFactory(this.namespaceRegistry, this.decoder, this.stringFactory));
        this.objectFactory = StandardValueFactories.getFactory(factories, new ObjectValueFactory(this.decoder, this.stringFactory, this.binaryFactory));
    }

    private static <T> ValueFactory<T> getFactory(Map<PropertyType, ValueFactory<?>> factories, ValueFactory<T> defaultFactory) {
        PropertyType type = defaultFactory.getPropertyType();
        ValueFactory<Object> factory = factories.get((Object)type);
        if (factory == null) {
            factory = defaultFactory;
            factories.put(type, factory);
        }
        return factory;
    }

    public TextDecoder getTextDecoder() {
        return this.decoder;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    @Override
    public BinaryFactory getBinaryFactory() {
        return this.binaryFactory;
    }

    @Override
    public ValueFactory<Boolean> getBooleanFactory() {
        return this.booleanFactory;
    }

    @Override
    public DateTimeFactory getDateFactory() {
        return this.dateFactory;
    }

    @Override
    public ValueFactory<BigDecimal> getDecimalFactory() {
        return this.decimalFactory;
    }

    @Override
    public ValueFactory<Double> getDoubleFactory() {
        return this.doubleFactory;
    }

    @Override
    public ValueFactory<Long> getLongFactory() {
        return this.longFactory;
    }

    @Override
    public NameFactory getNameFactory() {
        return this.nameFactory;
    }

    @Override
    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    @Override
    public ValueFactory<Reference> getReferenceFactory() {
        return this.referenceFactory;
    }

    @Override
    public ValueFactory<String> getStringFactory() {
        return this.stringFactory;
    }

    @Override
    public ValueFactory<URI> getUriFactory() {
        return this.uriFactory;
    }

    @Override
    public UuidFactory getUuidFactory() {
        return this.uuidFactory;
    }

    @Override
    public ValueFactory<Object> getObjectFactory() {
        return this.objectFactory;
    }
}

