/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.NodeConflictBehavior;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.ChangeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNodeRequest
extends ChangeRequest
implements Iterable<Property> {
    private static final long serialVersionUID = 1L;
    public static final NodeConflictBehavior DEFAULT_CONFLICT_BEHAVIOR = NodeConflictBehavior.APPEND;
    private final Location under;
    private final String workspaceName;
    private final Name childName;
    private final List<Property> properties;
    private final NodeConflictBehavior conflictBehavior;
    private Location actualLocation;

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, Property ... properties) {
        this(parentLocation, workspaceName, childName, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, Iterable<Property> properties) {
        this(parentLocation, workspaceName, childName, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, Iterator<Property> properties) {
        this(parentLocation, workspaceName, childName, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, NodeConflictBehavior conflictBehavior, Property ... properties) {
        CheckArg.isNotNull((Object)parentLocation, (String)"parentLocation");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        CheckArg.isNotNull((Object)childName, (String)"childName");
        this.under = parentLocation;
        this.workspaceName = workspaceName;
        this.childName = childName;
        this.conflictBehavior = conflictBehavior;
        int number = properties.length + (this.under.hasIdProperties() ? this.under.getIdProperties().size() : 0);
        ArrayList<Property> props = new ArrayList<Property>(number);
        for (Property property : properties) {
            if (property == null) continue;
            props.add(property);
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, NodeConflictBehavior conflictBehavior, Iterable<Property> properties) {
        CheckArg.isNotNull((Object)parentLocation, (String)"parentLocation");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        CheckArg.isNotNull((Object)childName, (String)"childName");
        this.under = parentLocation;
        this.workspaceName = workspaceName;
        this.childName = childName;
        this.conflictBehavior = conflictBehavior;
        LinkedList<Property> props = new LinkedList<Property>();
        for (Property property : properties) {
            if (property == null) continue;
            props.add(property);
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, NodeConflictBehavior conflictBehavior, Iterator<Property> properties) {
        CheckArg.isNotNull((Object)parentLocation, (String)"parentLocation");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        CheckArg.isNotNull((Object)childName, (String)"childName");
        this.under = parentLocation;
        this.workspaceName = workspaceName;
        this.childName = childName;
        this.conflictBehavior = conflictBehavior;
        LinkedList<Property> props = new LinkedList<Property>();
        while (properties.hasNext()) {
            Property property = properties.next();
            if (property == null) continue;
            props.add(property);
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public Location under() {
        return this.under;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name named() {
        return this.childName;
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties.iterator();
    }

    public Collection<Property> properties() {
        return this.properties;
    }

    public NodeConflictBehavior conflictBehavior() {
        return this.conflictBehavior;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)actual, (String)"actual");
        if (!this.under.isSame(actual, false)) {
            // empty if block
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        assert (actual.hasPath());
        if (this.under.hasPath() && !this.under.getPath().equals(actual.getPath().getParent())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.under}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.under.hasPath() && this.under.getPath().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.actualLocation;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.under, this.childName, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CreateNodeRequest that = (CreateNodeRequest)obj;
            if (!this.under().equals(that.under())) {
                return false;
            }
            if (!this.conflictBehavior().equals((Object)that.conflictBehavior())) {
                return false;
            }
            if (!this.inWorkspace().equals((Object)that.conflictBehavior())) {
                return false;
            }
            return ((Object)this.properties()).equals(that.properties());
        }
        return false;
    }

    public String toString() {
        String parent = this.under() + "/";
        if (this.under.hasPath() && this.under.getPath().isRoot()) {
            parent = "/";
        }
        return "create in the \"" + this.workspaceName + "\" workspace the node \"" + parent + this.childName + "\" with properties " + this.properties();
    }
}

