/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.ChangeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteChildrenRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private Location actualLocation;
    private List<Location> actualChildrenDeleted = new LinkedList<Location>();

    public DeleteChildrenRequest(Location at, String workspaceName) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        if (!this.at.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.at}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public void addDeletedChildren(Iterable<Location> children) {
        this.checkNotFrozen();
        CheckArg.isNotNull(children, (String)"children");
        for (Location child : children) {
            if (child == null) continue;
            this.actualChildrenDeleted.add(child);
        }
    }

    public void addDeletedChild(Location child) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)child, (String)"child");
        this.actualChildrenDeleted.add(child);
    }

    public void addDeletedChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, firstIdProperty, remainingIdProperties);
        this.actualChildrenDeleted.add(child);
    }

    public void addDeletedChild(Path pathToChild, Property idProperty) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, idProperty);
        this.actualChildrenDeleted.add(child);
    }

    public List<Location> getActualChildrenDeleted() {
        return this.actualChildrenDeleted;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.at.hasPath() && this.at.getPath().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.at;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            DeleteChildrenRequest that = (DeleteChildrenRequest)obj;
            if (!this.at().equals(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "delete nodes below " + this.at() + " in the \"" + this.workspaceName + "\" workspace";
    }
}

