/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.CacheableRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadAllChildrenRequest
extends CacheableRequest
implements Iterable<Location> {
    private static final long serialVersionUID = 1L;
    private final Location of;
    private final String workspaceName;
    private final List<Location> children = new LinkedList<Location>();
    private Location actualOf;

    public ReadAllChildrenRequest(Location of, String workspaceName) {
        CheckArg.isNotNull((Object)of, (String)"of");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.of = of;
        this.workspaceName = workspaceName;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location of() {
        return this.of;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public List<Location> getChildren() {
        return this.children;
    }

    @Override
    public Iterator<Location> iterator() {
        return this.children.iterator();
    }

    public void addChildren(Iterable<Location> children) {
        this.checkNotFrozen();
        CheckArg.isNotNull(children, (String)"children");
        for (Location child : children) {
            if (child == null) continue;
            this.children.add(child);
        }
    }

    public void addChild(Location child) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)child, (String)"child");
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, firstIdProperty, remainingIdProperties);
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property idProperty) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, idProperty);
        this.children.add(child);
    }

    public void setActualLocationOfNode(Location actualLocation) {
        this.checkNotFrozen();
        if (!this.of.isSame(actualLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actualLocation, this.of}));
        }
        assert (actualLocation != null);
        if (!actualLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actualLocation}));
        }
        this.actualOf = actualLocation;
    }

    public Location getActualLocationOfNode() {
        return this.actualOf;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualOf = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.of, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadAllChildrenRequest that = (ReadAllChildrenRequest)obj;
            if (!this.of().equals(that.of())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        String workspaceName = this.workspaceName != null ? "\"" + this.workspaceName + "\"" : "default";
        return "read children of " + this.of() + " in the \"" + workspaceName + "\" workspace";
    }
}

