/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.CacheableRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadNodeRequest
extends CacheableRequest
implements Iterable<Location> {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private final Map<Name, Property> properties = new HashMap<Name, Property>();
    private final List<Location> children = new LinkedList<Location>();
    private Location actualLocation;

    public ReadNodeRequest(Location at, String workspaceName) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Map<Name, Property> getPropertiesByName() {
        return this.properties;
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public Property addProperty(Property property) {
        this.checkNotFrozen();
        return this.properties.put(property.getName(), property);
    }

    public void addProperties(Property ... properties) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)properties, (String)"properties");
        for (Property property : properties) {
            this.properties.put(property.getName(), property);
        }
    }

    public void addProperties(Iterable<Property> properties) {
        this.checkNotFrozen();
        CheckArg.isNotNull(properties, (String)"properties");
        for (Property property : properties) {
            this.properties.put(property.getName(), property);
        }
    }

    public List<Location> getChildren() {
        return this.children;
    }

    @Override
    public Iterator<Location> iterator() {
        return this.children.iterator();
    }

    public void addChildren(Iterable<Location> children) {
        this.checkNotFrozen();
        CheckArg.isNotNull(children, (String)"children");
        for (Location child : children) {
            if (child == null) continue;
            this.children.add(child);
        }
    }

    public void addChild(Location child) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)child, (String)"child");
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, firstIdProperty, remainingIdProperties);
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property idProperty) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, idProperty);
        this.children.add(child);
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        if (!this.at.isSame(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{actual, this.at}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
        this.children.clear();
        this.properties.clear();
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.at, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadNodeRequest that = (ReadNodeRequest)obj;
            if (!this.at().equals(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "read node at " + this.at() + " in the \"" + this.workspaceName + "\" workspace";
    }
}

