/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.request.ChangeRequest;

public class RenameNodeRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private final Name newName;
    private Location actualOldLocation;
    private Location actualNewLocation;

    public RenameNodeRequest(Location at, String workspaceName, Name newName) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)newName, (String)"newName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
        this.newName = newName;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name toName() {
        return this.newName;
    }

    public void setActualLocations(Location oldLocation, Location newLocation) {
        this.checkNotFrozen();
        if (!this.at.isSame(oldLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{oldLocation, this.at}));
        }
        assert (oldLocation != null);
        if (newLocation == null) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotSameAsInputLocation.text(new Object[]{newLocation, this.at}));
        }
        if (!oldLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{oldLocation}));
        }
        if (!newLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(new Object[]{newLocation}));
        }
        Path newPath = newLocation.getPath();
        if (!newPath.getParent().equals(oldLocation.getPath().getParent())) {
            String msg = GraphI18n.actualNewLocationMustHaveSameParentAsOldLocation.text(new Object[]{newLocation, oldLocation});
            throw new IllegalArgumentException(msg);
        }
        if (!newPath.getLastSegment().getName().equals(this.toName())) {
            String msg = GraphI18n.actualNewLocationMustHaveSameNameAsRequest.text(new Object[]{newLocation, this.toName()});
            throw new IllegalArgumentException(msg);
        }
        this.actualNewLocation = newLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualOldLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualNewLocation;
    }

    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.at.hasPath() && this.at.getPath().getParent().isAtOrBelow(path);
    }

    public Location changedLocation() {
        return this.at;
    }

    public String changedWorkspace() {
        return this.workspaceName;
    }

    public void cancel() {
        super.cancel();
        this.actualNewLocation = null;
        this.actualOldLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.at, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            RenameNodeRequest that = (RenameNodeRequest)obj;
            if (!this.at().equals(that.at())) {
                return false;
            }
            if (!this.toName().equals(that.toName())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "rename node at " + this.at() + " in the \"" + this.workspaceName + "\" workspace to " + this.toName();
    }
}

