/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request.processor;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.observe.Changes;
import org.jboss.dna.graph.observe.Observer;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.CacheableRequest;
import org.jboss.dna.graph.request.ChangeRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CompositeRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DeleteChildrenRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidRequestException;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.ReadBlockOfChildrenRequest;
import org.jboss.dna.graph.request.ReadBranchRequest;
import org.jboss.dna.graph.request.ReadNextBlockOfChildrenRequest;
import org.jboss.dna.graph.request.ReadNodeRequest;
import org.jboss.dna.graph.request.ReadPropertyRequest;
import org.jboss.dna.graph.request.RemovePropertyRequest;
import org.jboss.dna.graph.request.RenameNodeRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.SetPropertyRequest;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyNodeExistsRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;

@Immutable
public abstract class RequestProcessor {
    private final ExecutionContext context;
    private final String sourceName;
    private final DateTime nowInUtc;
    private final CachePolicy defaultCachePolicy;
    private final List<ChangeRequest> changes;
    private final Observer observer;

    protected RequestProcessor(String sourceName, ExecutionContext context, Observer observer) {
        this(sourceName, context, observer, null, null);
    }

    protected RequestProcessor(String sourceName, ExecutionContext context, Observer observer, DateTime now) {
        this(sourceName, context, observer, now, null);
    }

    protected RequestProcessor(String sourceName, ExecutionContext context, Observer observer, DateTime now, CachePolicy defaultCachePolicy) {
        CheckArg.isNotEmpty((String)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)context, (String)"context");
        this.context = context;
        this.sourceName = sourceName;
        this.nowInUtc = now != null ? now : context.getValueFactories().getDateFactory().createUtc();
        this.defaultCachePolicy = defaultCachePolicy;
        this.changes = observer != null ? new LinkedList() : null;
        this.observer = observer;
    }

    protected void recordChange(ChangeRequest request) {
        assert (request != null);
        assert (!request.isCancelled());
        assert (!request.hasError());
        if (this.changes != null) {
            this.changes.add(request);
        }
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final ExecutionContext getExecutionContext() {
        return this.context;
    }

    protected final DateTime getNowInUtc() {
        return this.nowInUtc;
    }

    protected final CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    protected void setCacheableInfo(CacheableRequest request) {
        if (request.getCachePolicy() == null && this.defaultCachePolicy != null) {
            request.setCachePolicy(this.defaultCachePolicy);
        }
        request.setTimeLoaded(this.nowInUtc);
    }

    protected void setCacheableInfo(CacheableRequest request, CachePolicy cachePolicy) {
        if (cachePolicy == null) {
            cachePolicy = this.defaultCachePolicy;
        }
        if (cachePolicy != null) {
            if (request.getCachePolicy() != null) {
                if (request.getCachePolicy().getTimeToLive() > cachePolicy.getTimeToLive()) {
                    request.setCachePolicy(cachePolicy);
                }
            } else {
                request.setCachePolicy(cachePolicy);
            }
        }
        request.setTimeLoaded(this.nowInUtc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Request request) {
        if (request == null) {
            return;
        }
        try {
            if (request.isCancelled()) {
                return;
            }
            if (request instanceof CompositeRequest) {
                this.process((CompositeRequest)request);
            } else if (request instanceof CopyBranchRequest) {
                this.process((CopyBranchRequest)request);
            } else if (request instanceof CreateNodeRequest) {
                this.process((CreateNodeRequest)request);
            } else if (request instanceof DeleteBranchRequest) {
                this.process((DeleteBranchRequest)request);
            } else if (request instanceof DeleteChildrenRequest) {
                this.process((DeleteChildrenRequest)request);
            } else if (request instanceof MoveBranchRequest) {
                this.process((MoveBranchRequest)request);
            } else if (request instanceof ReadAllChildrenRequest) {
                this.process((ReadAllChildrenRequest)request);
            } else if (request instanceof ReadNextBlockOfChildrenRequest) {
                this.process((ReadNextBlockOfChildrenRequest)request);
            } else if (request instanceof ReadBlockOfChildrenRequest) {
                this.process((ReadBlockOfChildrenRequest)request);
            } else if (request instanceof ReadBranchRequest) {
                this.process((ReadBranchRequest)request);
            } else if (request instanceof ReadNodeRequest) {
                this.process((ReadNodeRequest)request);
            } else if (request instanceof ReadAllPropertiesRequest) {
                this.process((ReadAllPropertiesRequest)request);
            } else if (request instanceof ReadPropertyRequest) {
                this.process((ReadPropertyRequest)request);
            } else if (request instanceof RemovePropertyRequest) {
                this.process((RemovePropertyRequest)request);
            } else if (request instanceof SetPropertyRequest) {
                this.process((SetPropertyRequest)request);
            } else if (request instanceof RenameNodeRequest) {
                this.process((RenameNodeRequest)request);
            } else if (request instanceof UpdatePropertiesRequest) {
                this.process((UpdatePropertiesRequest)request);
            } else if (request instanceof VerifyNodeExistsRequest) {
                this.process((VerifyNodeExistsRequest)request);
            } else if (request instanceof VerifyWorkspaceRequest) {
                this.process((VerifyWorkspaceRequest)request);
            } else if (request instanceof GetWorkspacesRequest) {
                this.process((GetWorkspacesRequest)request);
            } else if (request instanceof CreateWorkspaceRequest) {
                this.process((CreateWorkspaceRequest)request);
            } else if (request instanceof CloneWorkspaceRequest) {
                this.process((CloneWorkspaceRequest)request);
            } else if (request instanceof DestroyWorkspaceRequest) {
                this.process((DestroyWorkspaceRequest)request);
            } else {
                this.processUnknownRequest(request);
            }
        }
        finally {
            this.completeRequest(request);
        }
    }

    protected void completeRequest(Request request) {
        request.freeze();
    }

    public void process(CompositeRequest request) {
        if (request == null) {
            return;
        }
        int numberOfErrors = 0;
        LinkedList<Throwable> errors = null;
        for (Request embedded : request) {
            assert (embedded != null);
            if (embedded.isCancelled()) {
                return;
            }
            this.process(embedded);
            if (!embedded.hasError()) continue;
            if (numberOfErrors == 0) {
                errors = new LinkedList<Throwable>();
            }
            assert (errors != null);
            errors.add(embedded.getError());
            ++numberOfErrors;
        }
        if (numberOfErrors == 0) {
            return;
        }
        assert (errors != null);
        if (numberOfErrors == 1) {
            request.setError((Throwable)errors.get(0));
        } else {
            StringBuilder errorString = new StringBuilder();
            for (Throwable error : errors) {
                errorString.append("\n");
                errorString.append("\t" + error.getMessage());
            }
            String msg = null;
            msg = request.size() == Integer.MAX_VALUE ? GraphI18n.multipleErrorsWhileExecutingManyRequests.text(new Object[]{numberOfErrors, errorString.toString()}) : GraphI18n.multipleErrorsWhileExecutingRequests.text(new Object[]{numberOfErrors, request.size(), errorString.toString()});
            request.setError(new RepositorySourceException(this.getSourceName(), msg));
        }
    }

    protected void processUnknownRequest(Request request) {
        request.setError(new InvalidRequestException(GraphI18n.unsupportedRequestType.text(new Object[]{request.getClass().getName(), request})));
    }

    public abstract void process(VerifyWorkspaceRequest var1);

    public abstract void process(GetWorkspacesRequest var1);

    public abstract void process(CreateWorkspaceRequest var1);

    public abstract void process(CloneWorkspaceRequest var1);

    public abstract void process(DestroyWorkspaceRequest var1);

    public abstract void process(CopyBranchRequest var1);

    public abstract void process(CreateNodeRequest var1);

    public abstract void process(DeleteBranchRequest var1);

    public void process(DeleteChildrenRequest request) {
        if (request == null) {
            return;
        }
        if (request.isCancelled()) {
            return;
        }
        ReadAllChildrenRequest readChildren = new ReadAllChildrenRequest(request.at(), request.inWorkspace());
        this.process(readChildren);
        if (readChildren.hasError()) {
            request.setError(readChildren.getError());
            return;
        }
        if (readChildren.isCancelled()) {
            return;
        }
        for (Location child : readChildren) {
            if (request.isCancelled()) {
                return;
            }
            DeleteBranchRequest deleteChild = new DeleteBranchRequest(child, request.inWorkspace());
            this.process(deleteChild);
            request.addDeletedChild(child);
        }
        request.setActualLocationOfNode(readChildren.getActualLocationOfNode());
    }

    public abstract void process(MoveBranchRequest var1);

    public abstract void process(ReadAllChildrenRequest var1);

    public void process(ReadBlockOfChildrenRequest request) {
        if (request == null) {
            return;
        }
        ReadAllChildrenRequest readAll = new ReadAllChildrenRequest(request.of(), request.inWorkspace());
        this.process(readAll);
        if (readAll.hasError()) {
            request.setError(readAll.getError());
            return;
        }
        List<Location> allChildren = readAll.getChildren();
        if (allChildren.size() < request.startingAtIndex()) {
            return;
        }
        int endIndex = Math.min(request.endingBefore(), allChildren.size());
        for (int i = request.startingAtIndex(); i != endIndex; ++i) {
            request.addChild(allChildren.get(i));
        }
        request.setActualLocationOfNode(readAll.getActualLocationOfNode());
        this.setCacheableInfo(request);
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        if (request == null) {
            return;
        }
        Location actualSiblingLocation = request.startingAfter();
        Path path = actualSiblingLocation.getPath();
        Path parentPath = null;
        if (path != null) {
            parentPath = path.getParent();
        }
        if (parentPath == null) {
            VerifyNodeExistsRequest verifySibling = new VerifyNodeExistsRequest(request.startingAfter(), request.inWorkspace());
            this.process(verifySibling);
            actualSiblingLocation = verifySibling.getActualLocationOfNode();
            parentPath = actualSiblingLocation.getPath().getParent();
        }
        assert (parentPath != null);
        ReadAllChildrenRequest readAll = new ReadAllChildrenRequest(Location.create(parentPath), request.inWorkspace());
        this.process(readAll);
        if (readAll.hasError()) {
            request.setError(readAll.getError());
            return;
        }
        List<Location> allChildren = readAll.getChildren();
        boolean found = false;
        int count = 0;
        for (Location child : allChildren) {
            if (count > request.count()) break;
            if (!found) {
                found = child.equals(request.startingAfter());
                continue;
            }
            ++count;
            request.addChild(child);
        }
        request.setActualLocationOfStartingAfterNode(actualSiblingLocation);
        this.setCacheableInfo(request);
    }

    public void process(ReadBranchRequest request) {
        if (request == null) {
            return;
        }
        LinkedList<LocationWithDepth> locationsToRead = new LinkedList<LocationWithDepth>();
        locationsToRead.add(new LocationWithDepth(request.at(), 1));
        boolean first = true;
        while (locationsToRead.peek() != null) {
            if (request.isCancelled()) {
                return;
            }
            LocationWithDepth read = (LocationWithDepth)locationsToRead.poll();
            if (read.depth > request.maximumDepth()) break;
            ReadNodeRequest readNode = new ReadNodeRequest(read.location, request.inWorkspace());
            this.process(readNode);
            if (readNode.hasError()) {
                request.setError(readNode.getError());
                return;
            }
            Location actualLocation = readNode.getActualLocationOfNode();
            if (first) {
                request.setActualLocationOfNode(actualLocation);
                first = false;
            }
            request.setChildren(actualLocation, readNode.getChildren());
            request.setProperties(actualLocation, readNode.getProperties());
            for (Location child : readNode.getChildren()) {
                locationsToRead.add(new LocationWithDepth(child, read.depth + 1));
            }
        }
        this.setCacheableInfo(request);
    }

    public abstract void process(ReadAllPropertiesRequest var1);

    public void process(ReadNodeRequest request) {
        if (request == null) {
            return;
        }
        ReadAllPropertiesRequest readProperties = new ReadAllPropertiesRequest(request.at(), request.inWorkspace());
        this.process(readProperties);
        if (readProperties.hasError()) {
            request.setError(readProperties.getError());
            return;
        }
        request.setActualLocationOfNode(readProperties.getActualLocationOfNode());
        ReadAllChildrenRequest readChildren = new ReadAllChildrenRequest(request.at(), request.inWorkspace());
        this.process(readChildren);
        if (readChildren.hasError()) {
            request.setError(readChildren.getError());
            return;
        }
        if (request.isCancelled()) {
            return;
        }
        for (Property property : readProperties) {
            request.addProperty(property);
        }
        for (Location child : readChildren) {
            request.addChild(child);
        }
        this.setCacheableInfo(request);
    }

    public void process(ReadPropertyRequest request) {
        if (request == null) {
            return;
        }
        ReadAllPropertiesRequest readNode = new ReadAllPropertiesRequest(request.on(), request.inWorkspace());
        this.process(readNode);
        if (readNode.hasError()) {
            request.setError(readNode.getError());
            return;
        }
        Property property = readNode.getPropertiesByName().get(request.named());
        request.setProperty(property);
        request.setActualLocationOfNode(readNode.getActualLocationOfNode());
        this.setCacheableInfo(request);
    }

    public void process(VerifyNodeExistsRequest request) {
        if (request == null) {
            return;
        }
        ReadAllPropertiesRequest readNode = new ReadAllPropertiesRequest(request.at(), request.inWorkspace());
        this.process(readNode);
        if (readNode.hasError()) {
            request.setError(readNode.getError());
            return;
        }
        request.setActualLocationOfNode(readNode.getActualLocationOfNode());
        this.setCacheableInfo(request);
    }

    public void process(RemovePropertyRequest request) {
        if (request == null) {
            return;
        }
        Map<Name, Object> properties = Collections.singletonMap(request.propertyName(), null);
        UpdatePropertiesRequest update = new UpdatePropertiesRequest(request.from(), request.inWorkspace(), properties);
        this.process(update);
        if (update.hasError()) {
            request.setError(update.getError());
        }
        request.setActualLocationOfNode(update.getActualLocationOfNode());
    }

    public void process(SetPropertyRequest request) {
        if (request == null) {
            return;
        }
        Property property = request.property();
        Map<Name, Property> properties = Collections.singletonMap(property.getName(), property);
        UpdatePropertiesRequest update = new UpdatePropertiesRequest(request.on(), request.inWorkspace(), properties);
        this.process(update);
        if (update.hasError()) {
            request.setError(update.getError());
        } else {
            request.setActualLocationOfNode(update.getActualLocationOfNode());
        }
    }

    public abstract void process(UpdatePropertiesRequest var1);

    public void process(RenameNodeRequest request) {
        if (request == null) {
            return;
        }
        Location from = request.at();
        if (!from.hasPath()) {
            throw new UnsupportedOperationException();
        }
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(from.getPath(), request.toName());
        Location to = Location.create(newPath);
        MoveBranchRequest move = new MoveBranchRequest(from, to, request.inWorkspace());
        this.process(move);
        request.setActualLocations(move.getActualLocationBefore(), move.getActualLocationAfter());
    }

    public void close() {
        if (this.observer != null && !this.changes.isEmpty()) {
            String userName = this.context.getSecurityContext() != null ? this.context.getSecurityContext().getUserName() : null;
            Changes changes = new Changes(userName, this.getSourceName(), this.getNowInUtc(), this.changes);
            this.observer.notify(changes);
        }
    }

    @Immutable
    protected static class LocationWithDepth {
        protected final Location location;
        protected final int depth;

        protected LocationWithDepth(Location location, int depth) {
            this.location = location;
            this.depth = depth;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public String toString() {
            return this.location.toString() + " at depth " + this.depth;
        }
    }
}

