/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.LocationWithPath;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class LocationWithPathAndProperties
extends LocationWithPath {
    private static final long serialVersionUID = 1L;
    private final List<Property> idProperties;

    LocationWithPathAndProperties(Path path, List<Property> idProperties) {
        super(path);
        assert (idProperties != null);
        assert (!idProperties.isEmpty());
        this.idProperties = Collections.unmodifiableList(idProperties);
    }

    @Override
    public final List<Property> getIdProperties() {
        return this.idProperties;
    }

    @Override
    public UUID getUuid() {
        Object value;
        Property property = this.getIdProperty(DnaLexicon.UUID);
        if (property != null && !property.isEmpty() && (value = property.getFirstValue()) instanceof UUID) {
            return (UUID)value;
        }
        return null;
    }

    @Override
    public boolean hasIdProperties() {
        return this.idProperties.size() > 0;
    }

    @Override
    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        if (this.hasIdProperties()) {
            ArrayList<Property> newIdProperties = new ArrayList<Property>(this.idProperties.size() + 1);
            for (Property property : this.idProperties) {
                if (newIdProperty.getName().equals(property.getName())) continue;
                newIdProperties.add(property);
            }
            newIdProperties.add(newIdProperty);
            newIdProperties = Collections.unmodifiableList(newIdProperties);
            return LocationWithPathAndProperties.create(this.getPath(), newIdProperties);
        }
        return LocationWithPathAndProperties.create(this.getPath(), newIdProperty);
    }

    @Override
    public Location with(Path newPath) {
        if (newPath == null || newPath.equals(this.getPath())) {
            return this;
        }
        return LocationWithPathAndProperties.create(newPath, this.idProperties);
    }

    @Override
    public Location with(UUID uuid) {
        Property existing;
        if (uuid == null) {
            return this;
        }
        BasicSingleValueProperty newProperty = new BasicSingleValueProperty(DnaLexicon.UUID, uuid);
        if (this.hasIdProperties() && (existing = this.getIdProperty(DnaLexicon.UUID)) != null && existing.equals(newProperty)) {
            return this;
        }
        ArrayList<Property> newIdProperties = new ArrayList<Property>(this.idProperties.size() + 1);
        newIdProperties.addAll(this.idProperties);
        newIdProperties.add(newProperty);
        return LocationWithPathAndProperties.create(this.getPath(), newIdProperties);
    }
}

