/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.util.Collections;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.LocationWithPathAndProperties;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.basic.BasicSingleValueProperty;

@Immutable
class LocationWithPathAndProperty
extends LocationWithPathAndProperties {
    private static final long serialVersionUID = 1L;

    LocationWithPathAndProperty(Path path, Property idProperty) {
        super(path, Collections.singletonList(idProperty));
        assert (idProperty != null);
        assert (!idProperty.isEmpty());
    }

    public final Property getIdProperty(Name name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        Property property = this.getIdProperties().get(0);
        return property.getName().equals(name) ? property : null;
    }

    public UUID getUuid() {
        Property property = this.getIdProperties().get(0);
        if (DnaLexicon.UUID.equals(property.getName())) {
            Object value = property.getFirstValue();
            if (value instanceof UUID) {
                return (UUID)value;
            }
            if (value instanceof String) {
                return UUID.fromString((String)value);
            }
        }
        return null;
    }

    public final boolean hasIdProperties() {
        return true;
    }

    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        Property idProperty = this.getIdProperties().get(0);
        if (newIdProperty.getName().equals(idProperty.getName())) {
            return Location.create(this.getPath(), newIdProperty);
        }
        return Location.create(this.getPath(), idProperty, newIdProperty);
    }

    public Location with(Path newPath) {
        if (newPath == null) {
            return Location.create(this.getIdProperties());
        }
        if (this.getPath().equals(newPath)) {
            return this;
        }
        Property idProperty = this.getIdProperties().get(0);
        return Location.create(newPath, idProperty);
    }

    public Location with(UUID uuid) {
        Property idProperty = this.getIdProperties().get(0);
        if (uuid == null) {
            return Location.create(this.getPath());
        }
        assert (!DnaLexicon.UUID.equals(idProperty.getName()));
        BasicSingleValueProperty newUuidProperty = new BasicSingleValueProperty(DnaLexicon.UUID, uuid);
        return Location.create(this.getPath(), idProperty, newUuidProperty);
    }
}

